/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.number.decimal;

import com.softicar.platform.common.core.utils.DevNull;
import com.softicar.platform.dom.elements.input.AbstractDomNumberInput;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DomBigDecimalInput
extends AbstractDomNumberInput {
    private static final int DEFAULT_SCALE = 9;
    private static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.HALF_UP;
    private int scale = 9;

    public DomBigDecimalInput() {
        this((BigDecimal)null);
    }

    public DomBigDecimalInput(BigDecimal value) {
        this.setBigDecimal(value);
    }

    public DomBigDecimalInput(BigDecimal value, int scale) {
        this.setBigDecimal(value, scale);
    }

    public void setBigDecimal(BigDecimal value) {
        if (value != null) {
            this.setValue(this.replacePointWithComma(value.toPlainString()));
            this.scale = value.scale();
        } else {
            this.setValue(null);
            this.scale = 9;
        }
    }

    public void setBigDecimal(BigDecimal value, int scale) {
        if (value != null) {
            value = value.setScale(scale, DEFAULT_ROUNDING_MODE);
        }
        this.setBigDecimal(value);
        this.scale = scale;
    }

    public BigDecimal getBigDecimalOrNull() {
        return this.getBigDecimalOrNull(false);
    }

    public BigDecimal getBigDecimalOrZero() {
        BigDecimal value = this.getBigDecimalOrNull(false);
        return value != null ? value : BigDecimal.ZERO.setScale(this.scale);
    }

    public BigDecimal getBigDecimalOrNull(boolean stripTrailingZeros) {
        String value = this.getTextOrNull();
        if (value != null) {
            try {
                value = this.replaceCommaWithPoint(value);
                if (stripTrailingZeros) {
                    return new BigDecimal(value).setScale(this.scale, DEFAULT_ROUNDING_MODE).stripTrailingZeros();
                }
                return new BigDecimal(value).setScale(this.scale, DEFAULT_ROUNDING_MODE);
            }
            catch (NumberFormatException exception) {
                DevNull.swallow((Object)exception);
                return null;
            }
        }
        return null;
    }

    private String replacePointWithComma(String value) {
        return value != null ? value.replace(".", ",") : value;
    }

    private String replaceCommaWithPoint(String value) {
        return value != null ? value.replace(",", ".") : value;
    }

    public int getScale() {
        return this.scale;
    }
}

