/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.popup;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.element.IDomElement;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.bar.DomActionBar;
import com.softicar.platform.dom.elements.popup.DomPopupCloseManager;
import com.softicar.platform.dom.elements.popup.DomPopupFrame;
import com.softicar.platform.dom.elements.popup.button.DomPopupCancelButton;
import com.softicar.platform.dom.elements.popup.button.DomPopupCloseButton;
import com.softicar.platform.dom.elements.popup.position.DomPopupPosition;
import com.softicar.platform.dom.elements.popup.position.strategy.DomPopupEventCoordinatesPositionStrategy;
import com.softicar.platform.dom.elements.popup.position.strategy.DomPopupViewportCenterPositionStrategy;
import com.softicar.platform.dom.elements.popup.position.strategy.DomPopupViewportOriginPositionStrategy;
import com.softicar.platform.dom.elements.popup.position.strategy.IDomPopupPositionStrategy;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.style.CssPercent;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class DomPopup
extends DomDiv {
    protected final DomPopupFrame frame;
    private final DomPopupCloseManager closeActionManager = new DomPopupCloseManager(this, this::hidePopup);
    private IDomNode spawningNode = null;
    private boolean shown = false;
    private boolean displayHeader = true;
    private INullaryVoidFunction callbackBeforeShow;
    private DomActionBar actionBarFooter = null;
    private IDomPopupPositionStrategy positionStrategy;

    public DomPopup() {
        this.frame = new DomPopupFrame(this);
        this.callbackBeforeShow = INullaryVoidFunction.NO_OPERATION;
        this.setPositionByEvent();
        this.setCssClass(DomElementsCssClasses.DOM_POPUP);
    }

    public void setCaption(IDisplayString caption) {
        this.frame.setCaption(caption);
    }

    public void setSubCaption(IDisplayString subCaption) {
        this.frame.setSubCaption(subCaption);
    }

    public void setDisplayHeader(boolean displayHeader) {
        this.displayHeader = displayHeader;
    }

    public DomPopup setPositionByEvent() {
        this.positionStrategy = new DomPopupEventCoordinatesPositionStrategy();
        return this;
    }

    public DomPopup setPositionByViewportCenter() {
        this.setPositionByViewportCenter(CssPercent._50, CssPercent._50);
        return this;
    }

    public DomPopup setPositionByViewportCenter(CssPercent xPercent, CssPercent yPercent) {
        this.positionStrategy = new DomPopupViewportCenterPositionStrategy(xPercent, yPercent);
        return this;
    }

    public DomPopup setPositionByViewportOrigin() {
        this.setPositionByViewportOrigin(CssPercent._0, CssPercent._0);
        return this;
    }

    public DomPopup setPositionByViewportOrigin(CssPercent xPercent, CssPercent yPercent) {
        this.positionStrategy = new DomPopupViewportOriginPositionStrategy(xPercent, yPercent);
        return this;
    }

    public void show() {
        this.show(this.positionStrategy.getPosition(this.getCurrentEvent()));
    }

    public void hide() {
        this.closeActionManager.closePopupNonInteractive();
    }

    public boolean isShown() {
        return this.shown;
    }

    public void setCallbackBeforeShow(INullaryVoidFunction callback) {
        this.callbackBeforeShow = Objects.requireNonNull(callback);
    }

    public void focusFrameOrFirstInputElement() {
        this.getDomEngine().focus(this.frame);
        this.focusFirst();
    }

    public DomPopupCloseManager getCloseManager() {
        return this.closeActionManager;
    }

    public void setConfirmBeforeClose(boolean confirmBeforeClose) {
        this.closeActionManager.setConfirmBeforeClose(confirmBeforeClose);
    }

    public <T extends IDomNode> T appendActionNode(T node) {
        if (this.actionBarFooter == null) {
            this.appendNewChild(DomElementTag.HR);
            this.actionBarFooter = this.appendChild(new DomActionBar());
        }
        return this.actionBarFooter.appendChild(node);
    }

    public IDomElement appendCloseButton() {
        return this.appendActionNode(new DomPopupCloseButton(this));
    }

    public IDomElement appendCancelButton() {
        return this.appendActionNode(new DomPopupCancelButton(this));
    }

    protected void showBackdrop(Supplier<DomDiv> backdropSupplier) {
        DomDiv backdrop = backdropSupplier.get();
        this.getDomEngine().setMaximumZIndex(backdrop);
        this.getDomDocument().getBody().appendChild(backdrop);
        this.getCloseManager().setCloseCallback(() -> backdrop.disappend());
    }

    protected void trapTabFocus() {
        this.getDomEngine().trapTabFocus(this.frame);
    }

    private void show(DomPopupPosition position) {
        this.spawningNode = this.determineSpawningNode();
        if (this.frame.getParent() == null) {
            this.getDomDocument().getBody().appendChild(this.frame);
        }
        this.frame.initialize(this.displayHeader);
        this.callbackBeforeShow.apply();
        this.getDomEngine().showPopup(this.frame, position.getX(), position.getY(), position.getXAlign(), position.getYAlign());
        this.shown = true;
        this.focusFrameOrFirstInputElement();
    }

    private void hidePopup() {
        this.frame.disappend();
        this.getDomEngine().hidePopup(this.frame);
        this.shown = false;
        Optional.ofNullable(this.spawningNode).ifPresent(this.getDomEngine()::focus);
    }

    private IDomNode determineSpawningNode() {
        return Optional.ofNullable(this.getCurrentEvent()).map(IDomEvent::getCurrentTarget).orElse(null);
    }
}

