/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.popup;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.popup.DomPopup;

public class DomPopupCloseManager {
    private final DomPopup popup;
    private final INullaryVoidFunction hideCallback;
    private boolean confirmBeforeClose = false;
    private boolean removeChildrenOnClose = false;
    private INullaryVoidFunction closeCallback = null;

    public DomPopupCloseManager(DomPopup popup, INullaryVoidFunction hideCallback) {
        this.popup = popup;
        this.hideCallback = hideCallback;
    }

    public void setConfirmBeforeClose(boolean confirmBeforeClose) {
        this.confirmBeforeClose = confirmBeforeClose;
    }

    public void setRemoveChildrenOnClose(boolean removeChildrenOnClose) {
        this.removeChildrenOnClose = removeChildrenOnClose;
    }

    public void setCloseCallback(INullaryVoidFunction closeCallback) {
        this.closeCallback = closeCallback;
    }

    public void closePopupInteractive() {
        if (this.confirmBeforeClose) {
            this.popup.executeConfirm(this::executeCloseActions, (IDisplayString)DomI18n.ARE_YOU_SURE_TO_CLOSE_THIS_WINDOW_QUESTION);
        } else {
            this.executeCloseActions();
        }
    }

    public void closePopupNonInteractive() {
        this.executeCloseActions();
    }

    private void executeCloseActions() {
        if (this.removeChildrenOnClose) {
            this.popup.removeChildren();
        }
        if (this.closeCallback != null) {
            this.closeCallback.apply();
        }
        this.hideCallback.apply();
    }
}

