/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.popup;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.DomCssPseudoClasses;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.popup.DomPopup;
import com.softicar.platform.dom.elements.popup.DomPopupFrameHeader;
import com.softicar.platform.dom.elements.popup.IDomPopupFrame;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomEscapeKeyEventHandler;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.styles.CssPosition;
import java.util.Collections;

public class DomPopupFrame
extends DomDiv
implements IDomPopupFrame,
IDomEscapeKeyEventHandler {
    private final DomPopupFrameHeader header = new DomPopupFrameHeader(this);
    private final DomPopup popup;
    private boolean initialized;

    DomPopupFrame(DomPopup popup) {
        this.popup = popup;
        this.initialized = false;
        this.setCssClass(DomElementsCssClasses.DOM_POPUP_FRAME);
        this.makeDraggable(CssPosition.ABSOLUTE, this.header);
        this.setupEscapeHandler();
    }

    @Override
    public void handleEscapeKey(IDomEvent event) {
        this.closePopup();
    }

    @Override
    public void closePopup() {
        this.popup.getCloseManager().closePopupInteractive();
    }

    public void setCaption(IDisplayString text) {
        this.header.setCaption(text);
    }

    public void setSubCaption(IDisplayString text) {
        this.header.setSubCaption(text);
    }

    public void initialize(boolean displayHeader) {
        if (!this.initialized) {
            if (displayHeader) {
                this.appendChild(this.header);
            }
            this.appendChild(this.popup);
            this.initialized = true;
        }
    }

    private void setupEscapeHandler() {
        this.setTabIndex(0);
        this.getDomEngine().setFireOnKeyUp(this, DomEventType.ESCAPE, true);
        this.getDomEngine().setCssClassOnKeyDown(this, DomEventType.ESCAPE, this.header.getCloseButton(), Collections.singleton(DomCssPseudoClasses.ACTIVE));
    }
}

