/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.popup;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.popup.DomPopupFrame;
import com.softicar.platform.dom.elements.popup.DomPopupFrameCloseButton;

class DomPopupFrameHeader
extends DomDiv {
    private final CaptionHolder captionHolder = new CaptionHolder();
    private final DomPopupFrameCloseButton closeButton;

    public DomPopupFrameHeader(DomPopupFrame frame) {
        this.closeButton = new DomPopupFrameCloseButton(frame);
        this.setCssClass(DomElementsCssClasses.DOM_POPUP_FRAME_HEADER);
        this.appendChild(this.captionHolder);
        this.appendChild(this.closeButton);
    }

    public void setCaption(IDisplayString text) {
        this.captionHolder.captionDiv.removeChildren();
        this.captionHolder.captionDiv.appendText(text);
    }

    public void setSubCaption(IDisplayString text) {
        this.captionHolder.subCaptionDiv.removeChildren();
        this.captionHolder.subCaptionDiv.appendText(text);
    }

    public DomPopupFrameCloseButton getCloseButton() {
        return this.closeButton;
    }

    private static class CaptionHolder
    extends DomDiv {
        private final DomDiv captionDiv = new DomDiv();
        private final DomDiv subCaptionDiv;

        public CaptionHolder() {
            this.captionDiv.setCssClass(DomElementsCssClasses.DOM_POPUP_CAPTION);
            this.subCaptionDiv = new DomDiv();
            this.subCaptionDiv.setCssClass(DomElementsCssClasses.DOM_POPUP_SUB_CAPTION);
            this.appendChild(this.captionDiv);
            this.appendChild(this.subCaptionDiv);
        }
    }
}

