/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.prompt;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.dom.element.IDomElement;
import com.softicar.platform.dom.elements.prompt.DomPromptButton;
import com.softicar.platform.dom.elements.prompt.DomPromptButtonConfiguration;
import com.softicar.platform.dom.parent.IDomParentElement;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DomPromptButtonBuilder {
    private final DomPromptButtonConfiguration configuration = new DomPromptButtonConfiguration();

    public DomPromptButtonBuilder setLabel(IDisplayString label) {
        this.configuration.setLabel(label);
        return this;
    }

    public DomPromptButtonBuilder setTitle(IDisplayString title) {
        this.configuration.setTitle(title);
        return this;
    }

    public DomPromptButtonBuilder setIcon(IResource resource) {
        this.configuration.setIcon(resource);
        return this;
    }

    public DomPromptButtonBuilder setPromptCallback(Consumer<String> promptCallback) {
        this.configuration.setPromptCallback(promptCallback);
        return this;
    }

    public DomPromptButtonBuilder setPromptMessageSupplier(Supplier<IDisplayString> messageSupplier) {
        this.configuration.setPromptMessageSupplier(messageSupplier);
        return this;
    }

    public DomPromptButtonBuilder setPromptMessage(IDisplayString message) {
        return this.setPromptMessageSupplier(() -> message);
    }

    public DomPromptButtonBuilder setDefaultValueSupplier(Supplier<String> defaultValueSupplier) {
        this.configuration.setDefaultValueSupplier(defaultValueSupplier);
        return this;
    }

    public DomPromptButtonBuilder setDefaultValue(String defaultValue) {
        return this.setDefaultValueSupplier(() -> defaultValue);
    }

    public IDomElement build() {
        if (this.configuration.getPromptCallback() == null) {
            throw new IllegalStateException("No callback defined.");
        }
        return new DomPromptButton(this.configuration);
    }

    public IDomElement buildAndAppendTo(IDomParentElement element) {
        return element.appendChild(this.build());
    }
}

