/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.select.value.simple;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.Consumers;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.dom.elements.DomValueOption;
import com.softicar.platform.dom.elements.select.value.simple.DomSimpleValueSelectBuilder;
import com.softicar.platform.dom.elements.select.value.simple.IDomSimpleValueSelect;
import com.softicar.platform.dom.elements.select.value.simple.IDomSimpleValueSelectConfiguration;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.input.DomSelect;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DomSimpleValueSelect<V>
extends DomSelect<DomValueOption<V>>
implements IDomSimpleValueSelect<V> {
    protected final IDomSimpleValueSelectConfiguration<V> configuration;
    private final NavigableMap<V, DomValueOption<V>> valueMap;
    private Function<V, IDisplayString> displayStringFunction;
    private INullaryVoidFunction callbackOnChange;
    private DomValueOption<V> nilOption;

    public DomSimpleValueSelect() {
        this(Consumers.noOperation());
    }

    public DomSimpleValueSelect(Consumer<DomSimpleValueSelectBuilder<V>> configurator) {
        this(DomSimpleValueSelect.createAndConfigureBuilder(configurator));
    }

    public DomSimpleValueSelect(IDomSimpleValueSelectConfiguration<V> configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.valueMap = new TreeMap<DomValueOption<V>, DomValueOption<V>>(configuration.getValueComparator());
        this.displayStringFunction = configuration.getValueDisplayStringFunction();
        this.callbackOnChange = INullaryVoidFunction.NO_OPERATION;
        this.nilOption = null;
        this.setValues(configuration.getValues());
        configuration.getCallbackOnChange().ifPresent(iNullaryVoidFunction -> this.setCallbackOnChange((INullaryVoidFunction)iNullaryVoidFunction));
    }

    @Override
    public DomSimpleValueSelect<V> setValues(Collection<? extends V> values) {
        Optional<V> previousValue = this.getSelectedValue();
        this.reset();
        this.appendNilOptionIfAppropriate();
        this.appendValueOptions(values.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        this.selectFirstOption();
        this.executeCallbackIfChanged(previousValue);
        return this;
    }

    @Override
    public Optional<V> getSelectedValue() {
        return Optional.ofNullable((DomValueOption)this.getSelectedOption()).map(DomValueOption::getValue);
    }

    @Override
    public void selectValue(V value) {
        if (value == null && !this.configuration.isNilOptionAvailable()) {
            throw new IllegalArgumentException();
        }
        Optional<V> previousValue = this.getSelectedValue();
        this.selectOption(value);
        this.executeCallbackIfChanged(previousValue);
    }

    @Override
    public DomSimpleValueSelect<V> setCallbackOnChange(INullaryVoidFunction callbackOnChange) {
        this.callbackOnChange = Objects.requireNonNull(callbackOnChange);
        this.listenToEvent(DomEventType.CHANGE);
        return this;
    }

    @Override
    public void handleDOMEvent(IDomEvent event) {
        if (event.getType().equals((Object)DomEventType.CHANGE)) {
            this.executeCallbackOnChange();
        }
    }

    private void reset() {
        this.removeChildren();
        this.valueMap.clear();
        this.nilOption = null;
    }

    private void appendNilOptionIfAppropriate() {
        if (this.configuration.isNilOptionAvailable() && !this.containsNilOption()) {
            this.nilOption = this.appendChild(new DomValueOption<Object>(null, this.configuration.getNilOptionDisplayString()));
        }
    }

    private void appendValueOptions(Collection<? extends V> values) {
        for (V value : values) {
            this.valueMap.put((DomValueOption<V>)value, (DomValueOption<DomValueOption<V>>)this.createValueOption(value));
        }
        this.valueMap.values().forEach(this::appendChild);
    }

    private void selectFirstOption() {
        if (this.nilOption != null) {
            this.setSelectedOption(this.nilOption);
        } else if (!this.valueMap.isEmpty()) {
            this.setSelectedOption(this.valueMap.firstEntry().getValue());
        }
    }

    private DomValueOption<V> createValueOption(V value) {
        return new DomValueOption<V>(value, this.displayStringFunction.apply(value));
    }

    private void selectOption(V value) {
        if (value != null) {
            this.selectValueOption(value);
        } else {
            this.selectNilOption();
        }
    }

    private void selectValueOption(V value) {
        if (!this.containsValueOption(value)) {
            this.insertValueOption(value);
        }
        this.setSelectedOption((DomValueOption)this.valueMap.get(value));
    }

    private void selectNilOption() {
        this.setSelectedOption(this.nilOption);
    }

    private boolean containsValueOption(V value) {
        return this.valueMap.containsKey(value);
    }

    private boolean containsNilOption() {
        return this.nilOption != null;
    }

    private void insertValueOption(V value) {
        DomValueOption<V> option = this.createValueOption(value);
        this.valueMap.put((DomValueOption<V>)value, (DomValueOption<DomValueOption<V>>)option);
        NavigableMap<V, DomValueOption<V>> tailMap = this.valueMap.tailMap(value, false);
        if (tailMap.isEmpty()) {
            this.appendChild(option);
        } else {
            this.insertBefore(option, tailMap.firstEntry().getValue());
        }
    }

    private void executeCallbackIfChanged(Optional<V> previousValue) {
        if (this.configuration.getValueComparator().compare(previousValue.orElse(null), this.getSelectedValue().orElse(null)) != 0) {
            this.executeCallbackOnChange();
        }
    }

    private void executeCallbackOnChange() {
        this.callbackOnChange.apply();
    }

    private static <V> DomSimpleValueSelectBuilder<V> createAndConfigureBuilder(Consumer<DomSimpleValueSelectBuilder<V>> configurator) {
        Objects.requireNonNull(configurator);
        DomSimpleValueSelectBuilder builder = new DomSimpleValueSelectBuilder();
        configurator.accept(builder);
        return builder;
    }
}

