/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.select.value.simple.display;

import com.softicar.platform.common.core.i18n.IDisplayString;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;

class CollatingDisplayStringFunctionBasedComparator<T>
implements Comparator<T> {
    private static final int COLLATOR_DECOMPOSITION = 1;
    private static final int COLLATOR_STRENGTH = 1;
    private final Function<T, IDisplayString> displayStringFunction;
    private final Collator collator;

    public CollatingDisplayStringFunctionBasedComparator(Function<T, IDisplayString> displayStringFunction) {
        this.displayStringFunction = Objects.requireNonNull(displayStringFunction);
        Locale locale = Locale.ENGLISH;
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
        this.collator.setDecomposition(1);
    }

    @Override
    public int compare(T first, T second) {
        String firstDisplayString = this.displayStringFunction.apply(first).toString();
        String secondDisplayString = this.displayStringFunction.apply(second).toString();
        return this.collator.compare(firstDisplayString, secondDisplayString);
    }
}

