/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.select.value.simple.display;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.i18n.IDisplayable;
import com.softicar.platform.common.core.item.BasicItemComparator;
import com.softicar.platform.common.core.item.IBasicItem;
import com.softicar.platform.dom.elements.select.value.simple.display.CollatingDisplayStringFunctionBasedComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class DomSimpleValueSelectDefaultValueComparator<V>
implements Comparator<V> {
    private final Supplier<Function<V, IDisplayString>> displayStringFunctionSupplier;

    public DomSimpleValueSelectDefaultValueComparator(Supplier<Function<V, IDisplayString>> displayStringFunctionSupplier) {
        this.displayStringFunctionSupplier = Objects.requireNonNull(displayStringFunctionSupplier);
    }

    @Override
    public int compare(V first, V second) {
        if (this.isArgumentsCastableToAny(first, second, IDisplayable.class, IBasicItem.class)) {
            BasicItemComparator comparator;
            int result = 0;
            if (this.isArgumentsCastableTo(first, second, IDisplayable.class)) {
                comparator = new CollatingDisplayStringFunctionBasedComparator(this.displayStringFunctionSupplier.get());
                result = Comparator.nullsFirst(comparator).compare(first, second);
            }
            if (result == 0 && this.isArgumentsCastableTo(first, second, IBasicItem.class)) {
                comparator = BasicItemComparator.get();
                result = Comparator.nullsFirst(comparator).compare((IBasicItem)first, (IBasicItem)second);
            }
            return result;
        }
        Comparator<Object> comparator = Comparator.comparing(Object::toString);
        return Comparator.nullsFirst(comparator).compare(first, second);
    }

    private boolean isArgumentsCastableToAny(V first, V second, Class<?> ... targetClasses) {
        return Arrays.asList(targetClasses).stream().anyMatch(targetClass -> this.isArgumentsCastableTo(first, second, (Class<?>)targetClass));
    }

    private boolean isArgumentsCastableTo(V first, V second, Class<?> targetClass) {
        if (this.isArgumentCastableTo(first, targetClass) && this.isArgumentCastableTo(second, targetClass)) {
            return true;
        }
        if (this.isArgumentCastableTo(first, targetClass) && second == null) {
            return true;
        }
        return first == null && this.isArgumentCastableTo(second, targetClass);
    }

    private boolean isArgumentCastableTo(V argument, Class<?> targetClass) {
        return argument != null && targetClass.isAssignableFrom(argument.getClass());
    }
}

