/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tab;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.tab.DomTabBar;
import java.util.Optional;

public class DomTab
extends DomDiv {
    private final IDisplayString label;
    private DomTabBar tabBar;
    private INullaryVoidFunction onShowRefreshable;
    private INullaryVoidFunction onHideRefreshable;
    private Optional<IStaticObject> headerMarker;

    public DomTab(IDisplayString label) {
        this.label = label;
        this.headerMarker = Optional.empty();
    }

    public void show() {
        if (this.tabBar != null) {
            this.tabBar.showTab(this);
        }
    }

    protected IDisplayString getLabel() {
        return this.label;
    }

    protected void setTabBar(DomTabBar tabBar) {
        this.tabBar = tabBar;
    }

    public void setOnShowRefreshable(INullaryVoidFunction onShowRefreshable) {
        this.onShowRefreshable = onShowRefreshable;
    }

    public void executeOnShowRefreshable() {
        if (this.onShowRefreshable != null) {
            this.onShowRefreshable.apply();
        }
    }

    public void setOnHideRefreshable(INullaryVoidFunction onHideRefreshable) {
        this.onHideRefreshable = onHideRefreshable;
    }

    public void executeOnHideRefreshable() {
        if (this.onHideRefreshable != null) {
            this.onHideRefreshable.apply();
        }
    }

    public DomTab setHeaderMarker(IStaticObject headerMarker) {
        this.headerMarker = Optional.of(headerMarker);
        return this;
    }

    public Optional<IStaticObject> getHeaderMarker() {
        return this.headerMarker;
    }
}

