/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tab;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.tab.DomTab;
import com.softicar.platform.dom.elements.tab.DomTabBarContentContainer;
import com.softicar.platform.dom.elements.tab.DomTabHeader;
import com.softicar.platform.dom.elements.tab.DomTabHeaderSeparator;
import java.util.ArrayList;
import java.util.List;

public class DomTabBar
extends DomDiv {
    private final List<DomTab> tabs = new ArrayList<DomTab>();
    private final TabBarHeader tabBarHeaderContainer = new TabBarHeader();
    private final DomTabBarContentContainer tabContentContainer = new DomTabBarContentContainer(this);
    private DomTab currentTab = null;

    public DomTabBar() {
        this.setCssClass(DomElementsCssClasses.DOM_TAB_BAR);
        this.addCssClass(DomElementsCssClasses.DOM_TAB_BAR_HORIZONTAL);
        this.appendChild(this.tabBarHeaderContainer);
        this.appendChild(this.tabContentContainer);
    }

    public DomTabBar setVerticalDisplay() {
        this.removeCssClass(DomElementsCssClasses.DOM_TAB_BAR_HORIZONTAL);
        this.addCssClass(DomElementsCssClasses.DOM_TAB_BAR_VERTICAL);
        return this;
    }

    public DomTab appendTab(IDisplayString label) {
        return this.appendTab(new DomTab(label));
    }

    public DomTab appendTab(DomTab tab) {
        tab.setTabBar(this);
        this.tabs.add(tab);
        if (this.currentTab == null) {
            this.showTab(tab);
        } else {
            this.tabBarHeaderContainer.refresh();
        }
        return tab;
    }

    public void showTab(DomTab tab) {
        if (!this.tabs.contains(tab)) {
            throw new SofticarDeveloperException("You cannot show tab '%s' which is not appended to the tab bar '%s'.", new Object[]{tab, this});
        }
        if (this.currentTab != null) {
            this.currentTab.executeOnHideRefreshable();
        }
        this.currentTab = tab;
        this.tabBarHeaderContainer.refresh();
        this.tabContentContainer.refresh();
        this.currentTab.executeOnShowRefreshable();
    }

    public DomTab getCurrentTab() {
        return this.currentTab;
    }

    private class TabBarHeader
    extends DomDiv {
        public TabBarHeader() {
            this.setCssClass(DomElementsCssClasses.DOM_TAB_BAR_HEADER);
        }

        public void refresh() {
            this.removeChildren();
            for (DomTab tab : DomTabBar.this.tabs) {
                this.appendChild(new DomTabHeader(tab, DomTabBar.this));
                this.appendChild(new DomTabHeaderSeparator());
            }
        }
    }
}

