/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tab;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.element.IDomElement;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.tab.DomTab;
import com.softicar.platform.dom.elements.tab.DomTabBar;
import java.util.Objects;
import java.util.function.Supplier;

public class DomTabBuilder {
    private IDisplayString label = IDisplayString.EMPTY;
    private Supplier<IDomElement> contentSupplier = DomDiv::new;

    public DomTabBuilder setLabel(IDisplayString label) {
        this.label = Objects.requireNonNull(label);
        return this;
    }

    public DomTabBuilder setContentSupplier(Supplier<IDomElement> contentSupplier) {
        this.contentSupplier = Objects.requireNonNull(contentSupplier);
        return this;
    }

    public DomTab build() {
        Objects.requireNonNull(this.label);
        Objects.requireNonNull(this.contentSupplier);
        return new Tab();
    }

    public DomTab buildAndAppendTo(DomTabBar tabBar) {
        return tabBar.appendTab(this.build());
    }

    private class Tab
    extends DomTab {
        private boolean initialized;

        public Tab() {
            super(DomTabBuilder.this.label);
            this.initialized = false;
            this.setOnShowRefreshable(this::onShow);
        }

        private void onShow() {
            if (!this.initialized) {
                this.appendChild(DomTabBuilder.this.contentSupplier.get());
                this.initialized = true;
            }
        }
    }
}

