/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tables.pageable;

import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.element.DomElement;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTableMarker;
import com.softicar.platform.dom.elements.tables.pageable.IDomPageableTableConfiguration;
import com.softicar.platform.dom.elements.tables.pageable.IDomPageableTableNavigationButtonBuilder;
import com.softicar.platform.dom.elements.tables.pageable.navigation.DomPageableTableNavigation;
import com.softicar.platform.dom.elements.tables.pageable.navigation.IDomPageableTableNavigation;
import com.softicar.platform.dom.elements.tables.scrollable.DomScrollableTable;
import java.util.ArrayList;
import java.util.List;

public abstract class DomPageableTable
extends DomScrollableTable {
    public static final int DEFAULT_PAGE_SIZE = 20;
    private static final int MAX_LINES_PER_PAGE = 5000;
    private final List<IDomPageableTableNavigation> navigations = new ArrayList<IDomPageableTableNavigation>();
    private int currentPage;
    private int totalRowCount;
    private int pageSize;

    public DomPageableTable() {
        this.setMarker(DomPageableTableMarker.TABLE);
    }

    public DomPageableTable(IDomPageableTableConfiguration config) {
        this.pageSize = config.getPageSize();
    }

    public void reset(int totalRowCount, int pageSize) {
        this.currentPage = 0;
        this.totalRowCount = totalRowCount;
        this.pageSize = pageSize;
        this.clearRowCache();
        this.updateAll();
    }

    public DomElement createNavigation() {
        return this.createNavigation(null);
    }

    public DomElement createNavigation(IDomPageableTableNavigationButtonBuilder ... customButtonBuilders) {
        DomPageableTableNavigation navigation = new DomPageableTableNavigation(this, List.of(customButtonBuilders));
        this.navigations.add(navigation);
        navigation.update();
        return navigation;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int pageIndex) {
        this.currentPage = Math.max(Math.min(pageIndex, this.getPageCount() - 1), 0);
        this.updateAll();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.setPageSize(pageSize, true);
    }

    public void setPageSize(int pageSize, boolean doSetCurrentPage) {
        if (pageSize != this.pageSize) {
            if (pageSize > 5000) {
                throw new SofticarUserException(DomI18n.PLEASE_ENTER_A_LOWER_VALUE_FOR_THE_NUMBER_OF_ROWS_PER_PAGE_MAXIMUM_ARG1.toDisplay((Object)5000));
            }
            int currentFirst = this.currentPage * this.pageSize;
            this.pageSize = pageSize;
            if (doSetCurrentPage) {
                this.setCurrentPage(currentFirst % this.pageSize);
            }
        }
    }

    public int getPageCount() {
        int count = this.totalRowCount / this.pageSize;
        return this.totalRowCount % this.pageSize != 0 ? count + 1 : count;
    }

    public int getTotalRowCount() {
        return this.totalRowCount;
    }

    protected void updateAll() {
        int last = Math.min((this.currentPage + 1) * this.pageSize, this.totalRowCount) - 1;
        int first = this.currentPage * this.pageSize;
        this.show(first, last);
        for (IDomPageableTableNavigation navigation : this.navigations) {
            navigation.update();
        }
    }
}

