/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tables.pageable.navigation;

import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.bar.DomBar;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTable;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTableMarker;
import com.softicar.platform.dom.elements.tables.pageable.IDomPageableTableNavigationButtonBuilder;
import com.softicar.platform.dom.elements.tables.pageable.navigation.DomPageableTableNavigationPageList;
import com.softicar.platform.dom.elements.tables.pageable.navigation.GoToPageButton;
import com.softicar.platform.dom.elements.tables.pageable.navigation.IDomPageableTableNavigation;
import com.softicar.platform.dom.elements.tables.pageable.navigation.TurnPageButton;
import java.util.List;

public class DomPageableTableNavigation
extends DomBar
implements IDomPageableTableNavigation {
    private final DomPageableTable table;
    private final List<IDomPageableTableNavigationButtonBuilder> customButtonBuilders;

    public DomPageableTableNavigation(DomPageableTable table, List<IDomPageableTableNavigationButtonBuilder> customButtonBuilders) {
        this.table = table;
        this.customButtonBuilders = customButtonBuilders;
        this.setMarker(DomPageableTableMarker.NAVIGATION);
        this.addCssClass(DomElementsCssClasses.DOM_PAGEABLE_TABLE_NAVIGATION);
    }

    @Override
    public void update() {
        this.removeChildren();
        if (this.isOneOrMorePages()) {
            this.appendCustomButtons();
            if (this.isMoreThanOnePage()) {
                this.appendPageNavigationButtons();
            }
        }
    }

    private boolean isOneOrMorePages() {
        return this.table.getPageSize() >= 1 && this.table.getPageCount() >= 1;
    }

    private boolean isMoreThanOnePage() {
        return this.table.getPageCount() > 1;
    }

    private void appendCustomButtons() {
        this.customButtonBuilders.stream().filter(builder -> builder.isAuthorized()).map(builder -> builder.build()).forEach(this::appendChild);
    }

    private void appendPageNavigationButtons() {
        this.appendChild(new GoToPageButton(this.table));
        this.appendChild(new TurnPageButton(this.table, PagingDirection.BACKWARD));
        this.appendChild(new DomPageableTableNavigationPageList(this.table));
        this.appendChild(new TurnPageButton(this.table, PagingDirection.FORWARD));
    }

    static enum PagingDirection {
        BACKWARD,
        FORWARD;

    }
}

