/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tables.pageable.navigation;

import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTable;
import com.softicar.platform.dom.elements.tables.pageable.navigation.PageButton;

class DomPageableTableNavigationPageList
extends DomDiv {
    private static final int PAGE_RANGE = 4;
    private static final int ELLIPSIS_WIDTH = 1;
    private static final int ELLIPSIS_THRESHOLD = 13;
    private static final String ELLIPSIS_STRING = "...";

    public DomPageableTableNavigationPageList(DomPageableTable table) {
        this.setCssClass(DomElementsCssClasses.DOM_PAGEABLE_TABLE_NAVIGATION_PAGE_LIST);
        if (table.getPageCount() > 13) {
            int begin;
            int end;
            int lastPage = table.getPageCount() - 1;
            if (lastPage - (end = Math.min((begin = Math.max(table.getCurrentPage() - 4, 0)) + 8, lastPage)) < 4) {
                end = lastPage;
            }
            if (begin < 4) {
                for (int i = 0; i <= end; ++i) {
                    this.appendChild(new PageButton(table, i));
                }
            } else {
                this.appendChild(new PageButton(table, 0));
                this.appendChild(new PageButton(table, begin / 2, ELLIPSIS_STRING));
                for (int i = begin; i <= end; ++i) {
                    this.appendChild(new PageButton(table, i));
                }
            }
            if (end < lastPage) {
                this.appendChild(new PageButton(table, end + (lastPage - end) / 2, ELLIPSIS_STRING));
                this.appendChild(new PageButton(table, lastPage));
            }
        } else {
            for (int i = 0; i < table.getPageCount(); ++i) {
                this.appendChild(new PageButton(table, i));
            }
        }
    }
}

