/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tables.pageable.navigation;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.bar.DomBar;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.input.DomIntegerInput;
import com.softicar.platform.dom.elements.label.DomLabelGrid;
import com.softicar.platform.dom.elements.popup.DomPopup;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTable;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTableMarker;
import com.softicar.platform.dom.event.IDomEnterKeyEventHandler;
import com.softicar.platform.dom.event.IDomEvent;

class GoToPagePopup
extends DomPopup {
    private final DomPageableTable table;
    private PageNumberInput pageNumberInput;

    public GoToPagePopup(DomPageableTable table) {
        this.table = table;
        this.setCaption((IDisplayString)DomI18n.GO_TO_PAGE);
        this.addCssClass(DomElementsCssClasses.DOM_PAGEABLE_TABLE_NAVIGATION_GO_TO_PAGE_POPUP);
    }

    @Override
    public void show() {
        this.removeChildren();
        int totalPageCount = this.table.getPageCount();
        int currentPageNumber = this.table.getCurrentPage() + 1;
        DomBar pageNumberBar = new DomBar();
        this.pageNumberInput = new PageNumberInput();
        pageNumberBar.appendChild(this.pageNumberInput);
        pageNumberBar.appendText(" / " + totalPageCount);
        this.pageNumberInput.setValue("" + Math.min(currentPageNumber, totalPageCount));
        this.appendChild(new DomLabelGrid().add((IDisplayString)DomI18n.PAGE, pageNumberBar));
        this.appendActionNode(new OkayButton());
        this.appendCancelButton();
        super.show();
        this.pageNumberInput.focus();
        this.pageNumberInput.select();
    }

    private void applyCurrentPageToTableAndHide() {
        this.table.setCurrentPage(Math.max(Math.min(this.pageNumberInput.getInteger(), this.table.getPageCount()), 1) - 1);
        this.hide();
    }

    private class PageNumberInput
    extends DomIntegerInput
    implements IDomEnterKeyEventHandler {
        public PageNumberInput() {
            this.setMarker(DomPageableTableMarker.NAVIGATION_PAGE_GOTO_INPUT_ELEMENT);
        }

        @Override
        public void handleEnterKey(IDomEvent event) {
            GoToPagePopup.this.applyCurrentPageToTableAndHide();
        }
    }

    private class OkayButton
    extends DomButton {
        public OkayButton() {
            this.setIcon(DomElementsImages.DIALOG_OKAY.getResource());
            this.setLabel((IDisplayString)DomI18n.OK);
            this.setMarker(DomPageableTableMarker.NAVIGATION_PAGE_GOTO_EXECUTE_BUTTON);
            this.setClickCallback(this::handleClick);
        }

        private void handleClick() {
            GoToPagePopup.this.applyCurrentPageToTableAndHide();
        }
    }
}

