/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tables.pageable.navigation;

import com.softicar.platform.common.core.exceptions.SofticarUnknownEnumConstantException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTable;
import com.softicar.platform.dom.elements.tables.pageable.DomPageableTableMarker;
import com.softicar.platform.dom.elements.tables.pageable.navigation.DomPageableTableNavigation;

class TurnPageButton
extends DomButton {
    private final DomPageableTable table;
    private final DomPageableTableNavigation.PagingDirection pageTurnDirection;

    public TurnPageButton(DomPageableTable table, DomPageableTableNavigation.PagingDirection pageTurnDirection) {
        this.table = table;
        this.pageTurnDirection = pageTurnDirection;
        this.setClickCallback(this::handleClick);
        if (pageTurnDirection == DomPageableTableNavigation.PagingDirection.BACKWARD) {
            this.setIcon(DomElementsImages.PAGE_PREVIOUS.getResource());
            this.setTitle((IDisplayString)DomI18n.PREVIOUS_PAGE);
            this.setMarker(DomPageableTableMarker.NAVIGATION_PAGE_PREV_BUTTON);
        } else if (pageTurnDirection == DomPageableTableNavigation.PagingDirection.FORWARD) {
            this.setIcon(DomElementsImages.PAGE_NEXT.getResource());
            this.setTitle((IDisplayString)DomI18n.NEXT_PAGE);
            this.setMarker(DomPageableTableMarker.NAVIGATION_PAGE_NEXT_BUTTON);
        } else {
            throw new SofticarUnknownEnumConstantException((Enum)pageTurnDirection);
        }
    }

    private void handleClick() {
        int currentPage = this.table.getCurrentPage();
        if (this.pageTurnDirection == DomPageableTableNavigation.PagingDirection.BACKWARD) {
            this.table.setCurrentPage(currentPage - 1);
        } else if (this.pageTurnDirection == DomPageableTableNavigation.PagingDirection.FORWARD) {
            this.table.setCurrentPage(currentPage + 1);
        } else {
            throw new SofticarUnknownEnumConstantException((Enum)this.pageTurnDirection);
        }
    }
}

