/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.tables.scrollable;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.dom.elements.DomRow;
import com.softicar.platform.dom.elements.tables.DomDataTable;
import com.softicar.platform.dom.elements.tables.scrollable.hooks.IPostPagingHook;
import com.softicar.platform.dom.elements.tables.scrollable.hooks.IPostRowAppendingHook;
import com.softicar.platform.dom.elements.tables.scrollable.hooks.IPrePagingHook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class DomScrollableTable
extends DomDataTable {
    private final Map<Integer, DomRow> rowCache = new TreeMap<Integer, DomRow>();
    private IPrePagingHook prePagingHook = null;
    private IPostRowAppendingHook postRowAppendingHook = null;
    private IPostPagingHook postPagingHook = null;

    public void show(int first, int last) {
        this.getBody().removeChildren();
        if (first < 0 || last < 0 || first > last) {
            return;
        }
        if (this.prePagingHook != null) {
            this.prePagingHook.handlePrePaging();
        }
        Collection<DomRow> rows = this.getRows(first, last);
        for (DomRow row : rows) {
            this.getBody().appendChild(row);
            if (this.postRowAppendingHook == null) continue;
            this.postRowAppendingHook.handlePostRowAppending(row);
        }
        if (this.postPagingHook != null) {
            this.postPagingHook.handlePostPaging();
        }
    }

    public void clearRowCache() {
        this.rowCache.clear();
    }

    public List<DomRow> getDisplayedRows() {
        return this.getBody().getChildren().stream().map(node -> (DomRow)node).collect(Collectors.toList());
    }

    public Collection<DomRow> getRows(int first, int last) {
        ArrayList<DomRow> rows = new ArrayList<DomRow>(last - first + 1);
        Integer batchStart = null;
        for (int i = first; i <= last; ++i) {
            DomRow row = this.rowCache.get(i);
            if (row != null) {
                if (batchStart != null) {
                    rows.addAll(this.createAndCacheRows(batchStart, i - 1));
                    batchStart = null;
                }
                rows.add(row);
                continue;
            }
            if (batchStart != null) continue;
            batchStart = i;
        }
        if (batchStart != null) {
            rows.addAll(this.createAndCacheRows(batchStart, last));
        }
        return rows;
    }

    public Collection<DomRow> getRowsUncached(int first, int last) {
        return Collections.unmodifiableCollection(this.createRows(first, last));
    }

    protected abstract DomRow createRow(int var1);

    protected Collection<? extends DomRow> createRows(int first, int last) {
        if (first < 0 || last < 0 || first > last) {
            throw new SofticarDeveloperException("Invalid first %s and last %s: ", new Object[]{first, last});
        }
        ArrayList<DomRow> rows = new ArrayList<DomRow>(last - first + 1);
        for (int i = first; i <= last; ++i) {
            rows.add(this.createRow(i));
        }
        return rows;
    }

    private Collection<? extends DomRow> createAndCacheRows(int first, int last) {
        if (first < 0 || last < 0 || first > last) {
            throw new SofticarDeveloperException("Invalid first %s and last %s: ", new Object[]{first, last});
        }
        Collection<? extends DomRow> rows = this.createRows(first, last);
        for (DomRow domRow : rows) {
            this.rowCache.put(first++, domRow);
        }
        return rows;
    }

    public void setPostRowAppendingHook(IPostRowAppendingHook postRowAppendingHook) {
        this.postRowAppendingHook = postRowAppendingHook;
    }

    public void setPrePagingHook(IPrePagingHook prePagingHook) {
        this.prePagingHook = prePagingHook;
    }

    public void setPostPagingHook(IPostPagingHook postPagingHook) {
        this.postPagingHook = postPagingHook;
    }
}

