/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.testing.engine;

import com.softicar.platform.dom.DomProperties;
import com.softicar.platform.dom.document.CurrentDomDocument;
import com.softicar.platform.dom.document.DomDocument;
import com.softicar.platform.dom.elements.testing.engine.IDomTestEngineLazySetup;
import com.softicar.platform.dom.node.IDomNode;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractDomTestEngineLazySetup
implements IDomTestEngineLazySetup {
    private IDomNode node;
    private Supplier<IDomNode> nodeSupplier;
    private Function<Supplier<IDomNode>, IDomNode> nodeInitializer;

    protected AbstractDomTestEngineLazySetup() {
        System.setProperty(DomProperties.TEST_MODE.getPropertyName().toString(), "true");
        CurrentDomDocument.set(new DomDocument());
        this.node = null;
        this.nodeSupplier = null;
        this.nodeInitializer = Supplier::get;
    }

    @Override
    public IDomNode getBodyNode() {
        this.initializeNode();
        return this.node.getParent();
    }

    @Override
    public void setNodeSupplier(Supplier<IDomNode> nodeSupplier) {
        this.nodeSupplier = Objects.requireNonNull(nodeSupplier);
    }

    @Override
    public void setNodeInitializer(Function<Supplier<IDomNode>, IDomNode> nodeInitializer) {
        this.nodeInitializer = nodeInitializer;
    }

    private void initializeNode() {
        if (this.node == null) {
            this.flushRefreshBus();
            this.node = this.createNode();
        }
    }

    private void flushRefreshBus() {
        CurrentDomDocument.get().getRefreshBus().discardEvent();
    }

    private IDomNode createNode() {
        Objects.requireNonNull(this.nodeSupplier, "The node supplier must be defined before this method is called.");
        return this.nodeInitializer.apply(this.nodeSupplier);
    }
}

