/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.testing.node.asserter;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.elements.tab.DomTab;
import com.softicar.platform.dom.elements.tab.DomTabBar;
import com.softicar.platform.dom.elements.tab.DomTabHeader;
import com.softicar.platform.dom.elements.testing.node.tester.DomNodeTester;
import com.softicar.platform.dom.node.IDomNode;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;

public class DomTabBarTestAsserter {
    private final DomNodeTester rootNode;

    public DomTabBarTestAsserter(DomNodeTester rootNode) {
        this.rootNode = Objects.requireNonNull(rootNode);
    }

    public void clickTabBarHeader(int index) {
        this.getMinNumberOfTabBarHeaders(index + 1).get(index).click();
    }

    public void assertTabBarAbsent() {
        this.rootNode.findNodes(DomTabBar.class).assertNone();
    }

    public DomTabBar assertTabBarPresent() {
        DomNodeTester tabBarTester = this.rootNode.findNodes(DomTabBar.class).assertOne();
        return (DomTabBar)tabBarTester.getNode();
    }

    public void assertTabBarHeaderCount(int count) {
        this.rootNode.findNodes(DomTabHeader.class).assertSize(count);
    }

    public void assertTabBarHeader(int index, String label) {
        this.assertTabBarHeader(index, IDisplayString.create((String)label));
    }

    public void assertTabBarHeader(int index, IDisplayString label) {
        this.getMinNumberOfTabBarHeaders(index + 1).get(index).assertContainsText(label);
    }

    public void assertCurrentTab(DomNodeTester tabTester) {
        this.assertCurrentTab((IDomNode)tabTester.getNode());
    }

    public void assertCurrentTab(IDomNode tab) {
        DomTabBar tabBar = this.assertTabBarPresent();
        DomTab currentTab = tabBar.getCurrentTab();
        Assert.assertSame((Object)tab, (Object)currentTab);
    }

    public List<DomNodeTester> getMinNumberOfTabBarHeaders(int minNumber) {
        return this.getMinNumberOfNodes(DomTabHeader.class, minNumber);
    }

    public <T extends IDomNode> List<DomNodeTester> getMinNumberOfNodes(Class<T> nodeClass, int minNumber) {
        List<DomNodeTester> nodes = this.getSomeNodes(nodeClass);
        if (nodes.size() < minNumber) {
            Assert.fail((String)String.format("Expected at least %s node(s) of type %s but encountered %s.", minNumber, nodeClass.getSimpleName(), nodes.size()));
        }
        return nodes;
    }

    public <T extends IDomNode> List<DomNodeTester> getSomeNodes(Class<T> nodeClass) {
        return this.rootNode.findNodes(nodeClass).assertSome();
    }
}

