/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.testing.node.iterable;

import com.softicar.platform.common.container.filter.FilteringIterable;
import com.softicar.platform.common.container.iterable.CastingIterable;
import com.softicar.platform.common.container.iterable.MappingIterable;
import com.softicar.platform.common.container.iterable.concat.ConcatIterable;
import com.softicar.platform.common.string.Imploder;
import com.softicar.platform.dom.elements.testing.engine.IDomTestEngine;
import com.softicar.platform.dom.elements.testing.node.DomNodeAssertionError;
import com.softicar.platform.dom.elements.testing.node.iterable.DomNodeRecursiveIterable;
import com.softicar.platform.dom.elements.testing.node.iterable.IDomNodeIterable;
import com.softicar.platform.dom.elements.testing.node.tester.DomNodeTester;
import com.softicar.platform.dom.node.IDomNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DomNodeIterable<N extends IDomNode>
implements IDomNodeIterable<N> {
    private final IDomTestEngine engine;
    private final Iterable<N> iterable;

    public DomNodeIterable(IDomTestEngine engine, Iterable<N> iterable) {
        this.engine = engine;
        this.iterable = iterable;
    }

    public static DomNodeIterable<IDomNode> createWithRoot(IDomTestEngine engine, IDomNode root) {
        return new DomNodeIterable<IDomNode>(engine, (Iterable<IDomNode>)new ConcatIterable(new Iterable[]{Collections.singletonList(root), new DomNodeRecursiveIterable(root)}));
    }

    public static DomNodeIterable<IDomNode> createWithoutRoot(IDomTestEngine engine, IDomNode root) {
        return new DomNodeIterable<IDomNode>(engine, (Iterable<IDomNode>)((Object)new DomNodeRecursiveIterable(root)));
    }

    @Override
    public IDomTestEngine getEngine() {
        return this.engine;
    }

    @Override
    public Iterator<N> iterator() {
        return this.iterable.iterator();
    }

    @Override
    public DomNodeTester first() {
        if (this.iterator().hasNext()) {
            return new DomNodeTester(this.getEngine(), (IDomNode)this.iterator().next());
        }
        throw new NoSuchElementException();
    }

    @Override
    public DomNodeTester last() {
        Iterator<N> iterator = this.iterator();
        if (iterator.hasNext()) {
            IDomNode node = null;
            while (iterator.hasNext()) {
                node = (IDomNode)iterator.next();
            }
            return new DomNodeTester(this.getEngine(), node);
        }
        throw new NoSuchElementException();
    }

    @Override
    public <Target extends IDomNode> IDomNodeIterable<Target> map(Function<N, Target> function) {
        return new DomNodeIterable<N>(this.engine, new MappingIterable(this.iterable, function));
    }

    @Override
    public IDomNodeIterable<N> filter(Predicate<N> predicate) {
        return new DomNodeIterable<N>(this.engine, new FilteringIterable((Iterable)this, predicate));
    }

    @Override
    public <Target extends IDomNode> IDomNodeIterable<Target> toType(Class<Target> type) {
        return new DomNodeIterable<N>(this.engine, new CastingIterable((Iterable)this, type));
    }

    @Override
    public IDomNodeIterable<N> withText(String text) {
        return this.filter(node -> new DomNodeTester(this.engine, (IDomNode)node).getAllTextInDocument("").equalsIgnoreCase(text));
    }

    @Override
    public IDomNodeIterable<N> startingWithText(String text) {
        return this.filter(node -> new DomNodeTester(this.engine, (IDomNode)node).getAllTextInDocument("").toLowerCase().startsWith(text.toLowerCase()));
    }

    @Override
    public IDomNodeIterable<N> startingWithTooltip(String tooltip) {
        return this.filter(node -> Optional.ofNullable(node.getAttribute("title")).map((? super T attribute) -> attribute.getValue()).map((? super T title) -> title.startsWith(tooltip)).orElse(false));
    }

    @Override
    public void assertNone(String message) {
        if (this.iterator().hasNext()) {
            throw new DomNodeAssertionError(message, "Expected to find no nodes but found %s nodes of the following classes:\n%s", this.size(), Imploder.implode(this.getNodeClassNames(), (String)"\n"));
        }
    }

    @Override
    public <T> T assertOne(String message, Function<N, T> factory) {
        Iterator<N> iterator = this.iterator();
        if (iterator.hasNext()) {
            IDomNode node = (IDomNode)iterator.next();
            if (iterator.hasNext()) {
                throw new DomNodeAssertionError(message, "Expected only one node but found %s nodes of the following classes:\n%s", this.size(), Imploder.implode(this.getNodeClassNames(), (String)"\n"));
            }
            return factory.apply(node);
        }
        throw new DomNodeAssertionError(message, "Expected one node but did not find any.", new Object[0]);
    }

    @Override
    public <T> List<T> assertSome(String message, Function<N, T> factory) {
        if (this.size() <= 0) {
            throw new DomNodeAssertionError(message, "Expected to find some nodes but found none.", new Object[0]);
        }
        return this.toList(factory);
    }

    @Override
    public <T> List<T> assertSize(String message, int size, Function<N, T> factory) {
        int actualSize = this.size();
        if (actualSize != size) {
            if (actualSize <= 0) {
                throw new DomNodeAssertionError(message, "Expected to find %s node(s) but found none.", size);
            }
            throw new DomNodeAssertionError(message, "Expected to find %s node(s) but found %s nodes of the following classes:\n%s", size, actualSize, Imploder.implode(this.getNodeClassNames(), (String)"\n"));
        }
        return this.toList(factory);
    }

    private Collection<String> getNodeClassNames() {
        return this.stream().map((? super T it) -> it.getClass().getCanonicalName()).collect(Collectors.toCollection(TreeSet::new));
    }
}

