/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.testing.node.iterable;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.dom.elements.testing.engine.IDomTestEngine;
import com.softicar.platform.dom.elements.testing.node.tester.DomNodeTester;
import com.softicar.platform.dom.node.IDomNode;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IDomNodeIterable<N extends IDomNode>
extends Iterable<N> {
    public IDomTestEngine getEngine();

    public DomNodeTester first();

    public DomNodeTester last();

    default public Stream<N> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public List<DomNodeTester> toList() {
        return this.stream().map((? super T node) -> new DomNodeTester(this.getEngine(), (IDomNode)node)).collect(Collectors.toList());
    }

    default public <T> List<T> toList(Function<N, T> factory) {
        return this.stream().map(factory).collect(Collectors.toList());
    }

    default public int size() {
        return (int)this.stream().count();
    }

    public <Target extends IDomNode> IDomNodeIterable<Target> map(Function<N, Target> var1);

    public IDomNodeIterable<N> filter(Predicate<N> var1);

    public <SubType extends IDomNode> IDomNodeIterable<SubType> toType(Class<SubType> var1);

    default public <Type extends IDomNode> IDomNodeIterable<Type> withType(Class<Type> type) {
        return this.withInstanceOf(type).toType(type);
    }

    default public IDomNodeIterable<N> withInstanceOf(Class<?> theClass) {
        return this.filter(node -> theClass.isInstance(node));
    }

    default public IDomNodeIterable<N> withMarker(IStaticObject ... marker) {
        return this.filter(node -> node.hasMarker(marker));
    }

    public IDomNodeIterable<N> withText(String var1);

    default public IDomNodeIterable<N> withText(IDisplayString text) {
        return this.withText(text.toString());
    }

    public IDomNodeIterable<N> startingWithText(String var1);

    default public IDomNodeIterable<N> startingWithText(IDisplayString text) {
        return this.startingWithText(text.toString());
    }

    public IDomNodeIterable<N> startingWithTooltip(String var1);

    default public IDomNodeIterable<N> startingWithTooltip(IDisplayString text) {
        return this.startingWithTooltip(text.toString());
    }

    default public void assertNone() {
        this.assertNone(null);
    }

    public void assertNone(String var1);

    default public DomNodeTester assertOne() {
        return this.assertOne((String)null);
    }

    default public DomNodeTester assertOne(String message) {
        return this.assertOne(message, node -> new DomNodeTester(this.getEngine(), (IDomNode)node));
    }

    default public <T> T assertOne(Function<N, T> factory) {
        return this.assertOne(null, factory);
    }

    public <T> T assertOne(String var1, Function<N, T> var2);

    default public List<DomNodeTester> assertSome() {
        return this.assertSome((String)null);
    }

    default public List<DomNodeTester> assertSome(String message) {
        return this.assertSome(message, node -> new DomNodeTester(this.getEngine(), (IDomNode)node));
    }

    default public <T> List<T> assertSome(Function<N, T> factory) {
        return this.assertSome(null, factory);
    }

    public <T> List<T> assertSome(String var1, Function<N, T> var2);

    default public List<DomNodeTester> assertSize(int size) {
        return this.assertSize(null, size);
    }

    default public <T> List<T> assertSize(int size, Function<N, T> factory) {
        return this.assertSize(null, size, factory);
    }

    default public List<DomNodeTester> assertSize(String message, int size) {
        return this.assertSize(message, size, node -> new DomNodeTester(this.getEngine(), (IDomNode)node));
    }

    public <T> List<T> assertSize(String var1, int var2, Function<N, T> var3);
}

