/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.testing.node.tester;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.dom.elements.testing.engine.IDomTestEngine;
import com.softicar.platform.dom.elements.testing.node.iterable.IDomNodeIterable;
import com.softicar.platform.dom.elements.testing.node.tester.DomNodeTester;
import com.softicar.platform.dom.elements.testing.node.tester.IDomNodeTesterFindMethods;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomClickEventHandler;
import com.softicar.platform.dom.input.IDomStringInputNode;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.parent.IDomParentElement;
import com.softicar.platform.dom.text.IDomTextNode;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class AbstractDomNodeTester<N extends IDomNode>
implements IDomNodeTesterFindMethods {
    private final IDomTestEngine engine;
    protected final N node;

    public AbstractDomNodeTester(IDomTestEngine engine, N node) {
        this.engine = engine;
        this.node = node;
    }

    @Override
    public IDomTestEngine getEngine() {
        return this.engine;
    }

    public N getNode() {
        return this.node;
    }

    public void setInputValue(IStaticObject marker, String value) {
        this.findNodes(marker).filter(this::hasStringInputNode).assertOne().findNode(IDomStringInputNode.class).setInputValue(value);
    }

    public AbstractDomNodeTester<N> setInputValue(String text) {
        if (!(this.node instanceof IDomStringInputNode)) {
            throw new AssertionError((Object)String.format("The node must be of type %s.", IDomStringInputNode.class.getSimpleName()));
        }
        this.engine.setInputValue((IDomStringInputNode)this.node, text);
        return this;
    }

    public String getInputValue() {
        if (this.node instanceof IDomStringInputNode) {
            return this.engine.getInputValue((IDomStringInputNode)this.node);
        }
        throw new AssertionError((Object)String.format("The node must be of type %s.", IDomStringInputNode.class.getSimpleName()));
    }

    public AbstractDomNodeTester<N> assertInputValue(String expectedValue) {
        String inputValue = this.getInputValue();
        if (expectedValue != null) {
            if (!expectedValue.equals(inputValue)) {
                throw new AssertionError((Object)String.format("Input value '%s' does not match expected value '%s'.", inputValue, expectedValue));
            }
        } else if (inputValue != null) {
            throw new AssertionError((Object)String.format("Expected null input value but encountered '%s'.", inputValue));
        }
        return this;
    }

    public void sendEvent(DomEventType type) {
        this.engine.sendEvent((IDomNode)this.node, type);
    }

    public AbstractDomNodeTester<N> click() {
        this.engine.sendEvent((IDomNode)this.node, DomEventType.CLICK);
        return this;
    }

    public AbstractDomNodeTester<N> doubleClick() {
        this.engine.sendEvent((IDomNode)this.node, DomEventType.DBLCLICK);
        return this;
    }

    public AbstractDomNodeTester<N> rightClick() {
        this.engine.sendEvent((IDomNode)this.node, DomEventType.CONTEXTMENU);
        return this;
    }

    public void clickNode(IStaticObject marker) {
        this.findNodes().withInstanceOf(IDomClickEventHandler.class).withMarker(marker).assertOne().click();
    }

    public void clickNode(IDisplayString text) {
        IDomNodeIterable<IDomNode> nodes = this.findNodes().withInstanceOf(IDomClickEventHandler.class).withText(text);
        if (nodes.size() == 1) {
            nodes.first().click();
        } else if (nodes.size() == 0) {
            this.findNodes().withInstanceOf(IDomClickEventHandler.class).startingWithText(text).assertOne().click();
        } else {
            throw new AssertionError((Object)String.format("Found more than one node with text '%s'", text));
        }
    }

    public <T extends N> T assertType(Class<T> concreteType) {
        if (concreteType.isInstance(this.node)) {
            return (T)((IDomNode)concreteType.cast(this.node));
        }
        throw new AssertionError((Object)String.format("Node of type %s is not instance of %s.", this.node.getClass().getCanonicalName(), concreteType.getCanonicalName()));
    }

    public AbstractDomNodeTester<N> assertContainsText(IDisplayString expectedText) {
        return this.assertContainsText(expectedText.toString());
    }

    public AbstractDomNodeTester<N> assertContainsText(String expectedText) {
        if (!this.containsText(expectedText)) {
            Assert.fail((String)String.format("Failed to find the text '%s' in the following: '%s'", expectedText, this.getAllTextInDocument("|")));
        }
        return this;
    }

    public AbstractDomNodeTester<N> assertDoesNotContainText(String expectedText) {
        if (this.containsText(expectedText)) {
            Assert.fail((String)String.format("Unexpectedly found the text '%s' in the following: '%s'", expectedText, this.getAllTextInDocument("|")));
        }
        return this;
    }

    public AbstractDomNodeTester<N> assertContainsNoText() {
        if (!this.containsNoText()) {
            Assert.fail((String)String.format("Did not expect to find text in the node but found: '%s'", this.getAllTextInDocument("|")));
        }
        return this;
    }

    public boolean isParentOf(IDomNode potentialChild) {
        IDomParentElement parent = potentialChild.getParent();
        if (parent != null) {
            return parent == this.node || this.isParentOf(parent);
        }
        return false;
    }

    public boolean containsText(String expectedText) {
        if (IDomTextNode.class.isAssignableFrom(this.node.getClass())) {
            return ((IDomTextNode)this.node).getText().contains(expectedText);
        }
        return this.getAllTextsInTree().filter(text -> text.contains(expectedText)).findFirst().isPresent();
    }

    public boolean containsNoText() {
        if (IDomTextNode.class.isAssignableFrom(this.node.getClass())) {
            return ((IDomTextNode)this.node).getText().equals("");
        }
        return this.getAllTextsInTree().collect(Collectors.joining()).equals("");
    }

    public String getAllTextInDocument(String delimiter) {
        return this.getAllTextsInTree().collect(Collectors.joining(delimiter));
    }

    public Stream<String> getAllTextsInTree() {
        if (IDomTextNode.class.isAssignableFrom(this.node.getClass())) {
            return Collections.singleton(((IDomTextNode)this.node).getText()).stream();
        }
        return this.findNodes().stream().filter(IDomTextNode.class::isInstance).map(IDomTextNode.class::cast).map(IDomTextNode::getText);
    }

    private boolean hasStringInputNode(IDomNode node) {
        return new DomNodeTester(this.engine, node).findNodes(IDomStringInputNode.class).size() > 0;
    }
}

