/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.testing.node.tester;

import com.softicar.platform.dom.elements.DomValueOption;
import com.softicar.platform.dom.elements.testing.engine.IDomTestEngine;
import com.softicar.platform.dom.elements.testing.node.tester.AbstractDomNodeTester;
import com.softicar.platform.dom.elements.testing.node.tester.DomNodeTester;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomEventHandler;
import com.softicar.platform.dom.input.DomSelect;
import com.softicar.platform.dom.node.IDomNode;
import java.util.Objects;
import org.junit.Assert;

public class DomSelectTester<T>
extends AbstractDomNodeTester<DomSelect<?>> {
    private final DomSelect<?> select;

    public DomSelectTester(IDomTestEngine engine, DomSelect<?> select) {
        super(engine, select);
        this.select = select;
    }

    public DomSelectTester<T> selectValue(T value) {
        DomValueOption option = this.findNodes(DomValueOption.class).filter(node -> Objects.equals(node.getValue(), value)).first().assertType(DomValueOption.class);
        ((DomSelect)this.node).setSelectedOptions_noJS("n" + option.getNodeId());
        if (this.node instanceof IDomEventHandler) {
            this.sendEvent(DomEventType.CHANGE);
        }
        return this;
    }

    public DomSelectTester<T> assertSelected(String expected) {
        this.assertSelected(null, expected);
        return this;
    }

    public DomSelectTester<T> assertSelected(String message, String expected) {
        Object selectedOption = this.select.getSelectedOption();
        if (expected != null) {
            Assert.assertNotNull((String)message, selectedOption);
            DomNodeTester optionTester = new DomNodeTester(this.getEngine(), (IDomNode)selectedOption);
            String selectedOptionText = optionTester.getAllTextsInTree().findFirst().orElseThrow();
            Assert.assertEquals((String)message, (Object)expected, (Object)selectedOptionText);
        } else {
            Assert.assertNull((String)message, selectedOption);
        }
        return this;
    }
}

