/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.testing.node.tester;

import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.common.core.utils.CastUtils;
import com.softicar.platform.dom.elements.DomTable;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.checkbox.DomCheckbox;
import com.softicar.platform.dom.elements.popup.DomPopup;
import com.softicar.platform.dom.elements.testing.engine.IDomTestEngine;
import com.softicar.platform.dom.elements.testing.node.iterable.DomNodeIterable;
import com.softicar.platform.dom.elements.testing.node.iterable.IDomNodeIterable;
import com.softicar.platform.dom.elements.testing.node.tester.DomCheckboxTester;
import com.softicar.platform.dom.elements.testing.node.tester.DomDayInputTester;
import com.softicar.platform.dom.elements.testing.node.tester.DomDayTimeInputTester;
import com.softicar.platform.dom.elements.testing.node.tester.DomNodeTester;
import com.softicar.platform.dom.elements.testing.node.tester.DomPopupTester;
import com.softicar.platform.dom.elements.testing.node.tester.DomSelectTester;
import com.softicar.platform.dom.elements.testing.node.tester.DomTableTester;
import com.softicar.platform.dom.elements.time.day.DomDayInput;
import com.softicar.platform.dom.elements.time.daytime.DomDayTimeInput;
import com.softicar.platform.dom.input.DomSelect;
import com.softicar.platform.dom.input.IDomInputNode;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.parent.IDomParentElement;

public interface IDomNodeTesterFindMethods {
    public IDomTestEngine getEngine();

    public IDomNode getNode();

    default public <T extends IDomNode> T getNode(Class<T> nodeClass) {
        return (T)((IDomNode)CastUtils.tryCast((Object)this.getNode(), nodeClass).orElseThrow());
    }

    default public IDomNodeIterable<IDomNode> findChildren() {
        return DomNodeIterable.createWithoutRoot(this.getEngine(), this.getNode());
    }

    default public IDomNodeIterable<IDomNode> findNodes() {
        return DomNodeIterable.createWithRoot(this.getEngine(), this.getNode());
    }

    default public IDomNodeIterable<IDomNode> findNodes(IStaticObject ... markers) {
        return this.findNodes().withMarker(markers);
    }

    default public <T extends IDomNode> IDomNodeIterable<T> findNodes(Class<T> nodeClass) {
        return this.findNodes().withType(nodeClass);
    }

    default public DomNodeTester findNode(IStaticObject ... markers) {
        return this.findNodes(markers).assertOne();
    }

    default public DomNodeTester findNode(Class<? extends IDomNode> nodeClass) {
        return this.findNodes(nodeClass).assertOne();
    }

    default public DomNodeTester findBody() {
        return new DomNodeTester(this.getEngine(), this.getEngine().getBodyNode());
    }

    default public DomPopupTester findPopup(IStaticObject ... markers) {
        return this.findNodes(markers).withType(DomPopup.class).assertOne(node -> new DomPopupTester(this.getEngine(), (DomPopup)node));
    }

    default public DomNodeTester findButton(IStaticObject marker) {
        return this.findNodes(marker).withType(DomButton.class).assertOne();
    }

    default public DomNodeTester findFirstButton(IStaticObject marker) {
        return this.findNodes(marker).withType(DomButton.class).assertSome().iterator().next();
    }

    default public DomNodeTester findInput(IStaticObject marker) {
        return this.findNodes(marker).withType(IDomInputNode.class).assertOne();
    }

    default public DomDayInputTester findDayInput(IStaticObject marker) {
        return this.findNodes(marker).withType(DomDayInput.class).assertOne(node -> new DomDayInputTester(this.getEngine(), (DomDayInput)node));
    }

    default public DomDayTimeInputTester findDayTimeInput(IStaticObject marker) {
        return this.findNodes(marker).withType(DomDayTimeInput.class).assertOne(node -> new DomDayTimeInputTester(this.getEngine(), (DomDayTimeInput)node));
    }

    default public DomCheckboxTester findCheckbox(IStaticObject marker) {
        return this.findNodes(marker).withType(DomCheckbox.class).assertOne(node -> new DomCheckboxTester(this.getEngine(), (DomCheckbox)node));
    }

    default public DomTableTester findTable(IStaticObject marker) {
        return this.findNodes(marker).withType(DomTable.class).assertOne(node -> new DomTableTester(this.getEngine(), (DomTable)node));
    }

    default public DomTableTester findTable() {
        return this.findNodes().withType(DomTable.class).assertOne(node -> new DomTableTester(this.getEngine(), (DomTable)node));
    }

    default public <T> DomSelectTester<T> findSelect(IStaticObject marker) {
        return this.findNode(marker).findNodes(DomSelect.class).assertOne(node -> new DomSelectTester(this.getEngine(), (DomSelect<?>)node));
    }

    default public DomNodeTester findParentOfType(Class<? extends IDomNode> parentClass) {
        for (IDomParentElement parent = this.getNode().getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            return new DomNodeTester(this.getEngine(), parent);
        }
        throw new AssertionError((Object)String.format("Expected node to have a parent of type %s.", parentClass.getCanonicalName()));
    }
}

