/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.time;

import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.date.DayTime;
import com.softicar.platform.common.date.Time;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.bar.DomBar;
import com.softicar.platform.dom.elements.input.DomIntegerInput;
import com.softicar.platform.dom.elements.label.DomPreformattedLabel;
import com.softicar.platform.dom.elements.tables.DomDataTable;

public class DomTimeInput
extends DomBar {
    private final DomIntegerInput hourInput = new DomIntegerInput();
    private final DomIntegerInput minuteInput;
    private final DomIntegerInput secondInput;

    public DomTimeInput() {
        this(DayTime.now().getTime());
    }

    public DomTimeInput(Time time) {
        this(time, false);
    }

    public DomTimeInput(Time time, boolean showLabels) {
        this.hourInput.setTitle((IDisplayString)DomI18n.HOURS);
        this.hourInput.addCssClass(DomElementsCssClasses.DOM_TIME_INPUT_ELEMENT);
        this.minuteInput = new DomIntegerInput();
        this.minuteInput.setTitle((IDisplayString)DomI18n.MINUTES);
        this.minuteInput.addCssClass(DomElementsCssClasses.DOM_TIME_INPUT_ELEMENT);
        this.secondInput = new DomIntegerInput();
        this.secondInput.setTitle((IDisplayString)DomI18n.SECONDS);
        this.secondInput.addCssClass(DomElementsCssClasses.DOM_TIME_INPUT_ELEMENT);
        if (showLabels) {
            DomDataTable table = new DomDataTable();
            table.getHead().appendRow().appendHeaderCells(new IDisplayString[]{DomI18n.HOURS, DomI18n.MINUTES, DomI18n.SECONDS});
            table.getBody().appendRow().appendCells(this.hourInput, this.minuteInput, this.secondInput);
            this.appendChild(table);
        } else {
            this.appendChildren(this.hourInput, new DomPreformattedLabel(":"), this.minuteInput, new DomPreformattedLabel(":"), this.secondInput);
        }
        this.setTime(time);
        this.addCssClass(DomElementsCssClasses.DOM_TIME_INPUT);
    }

    public Time getTime() {
        Integer hours = this.hourInput.getIntegerOrNull();
        Integer minutes = this.minuteInput.getIntegerOrNull();
        Integer seconds = this.secondInput.getIntegerOrNull();
        if (hours != null && minutes != null && seconds != null) {
            return new Time(hours.intValue(), minutes.intValue(), seconds.intValue());
        }
        if (hours == null && minutes == null && seconds == null) {
            return null;
        }
        throw new SofticarUserException(DomI18n.CANNOT_PARSE_TIME_WITH_ARG1_HOURS_ARG2_MINUTES_AND_ARG3_SECONDS.toDisplay((Object)hours, (Object)minutes, (Object)seconds));
    }

    public void setTime(Time time) {
        if (time != null) {
            this.hourInput.setInteger(time.getHour());
            this.minuteInput.setInteger(time.getMinute());
            this.secondInput.setInteger(time.getSecond());
        } else {
            this.clear();
        }
    }

    public void clear() {
        this.hourInput.setInteger(null);
        this.minuteInput.setInteger(null);
        this.secondInput.setInteger(null);
    }

    public void disableSeconds() {
        this.secondInput.setInteger(0);
        this.secondInput.disable();
    }
}

