/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.time.day;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.time.day.DomDayChooserDiv;
import com.softicar.platform.dom.elements.time.day.DomDayPopup;
import com.softicar.platform.dom.input.IDomInputNode;

public abstract class AbstractDomDayPopupButton
extends DomButton
implements IDomInputNode {
    private final DomDayPopup popup;
    private final DomDayChooserDiv chooser;
    private boolean showLabel = true;

    private AbstractDomDayPopupButton(DomDayChooserDiv chooser) {
        this.chooser = chooser;
        this.popup = new DomDayPopup(chooser, this);
        this.setIcon(DomElementsImages.CALENDAR_DAY.getResource());
        this.setLabel(IDisplayString.create((String)chooser.getDay().toString()));
        this.setClickCallback(() -> this.popup.show());
    }

    public AbstractDomDayPopupButton(Day day) {
        this(new DomDayChooserDiv(day));
    }

    public AbstractDomDayPopupButton() {
        this(new DomDayChooserDiv(Day.today()));
    }

    private void updateLabel() {
        this.setLabel(IDisplayString.create((String)(this.showLabel ? this.chooser.getDay().toISOString() : "")));
    }

    public Day getDay() {
        return this.chooser.getDay();
    }

    public void setDay(Day day) {
        this.chooser.setDay(day);
        this.updateLabel();
    }

    public void setShowLabel(boolean showLabel) {
        if (showLabel != this.showLabel) {
            this.showLabel = showLabel;
            this.updateLabel();
        }
    }

    protected void showPopup() {
        this.popup.show();
    }

    public abstract void handleDayChange();
}

