/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.time.day;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.date.DateItem;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.Month;
import com.softicar.platform.common.date.MonthName;
import com.softicar.platform.common.date.Week;
import com.softicar.platform.common.date.Weekday;
import com.softicar.platform.common.date.Year;
import com.softicar.platform.common.math.Range;
import com.softicar.platform.dom.DomCssPseudoClasses;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.AbstractDomValueSelect;
import com.softicar.platform.dom.elements.DomCell;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.DomRow;
import com.softicar.platform.dom.elements.DomTBody;
import com.softicar.platform.dom.elements.DomTHead;
import com.softicar.platform.dom.elements.DomTable;
import com.softicar.platform.dom.elements.bar.DomActionBar;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.event.IDomEventHandler;

public class DomDayChooserDiv
extends DomDiv {
    public static final int MINIMUM_YEAR = 1970;
    public static final int YEARS_INTO_THE_FUTURE = 20;
    private Day selectedDay;
    private final boolean readOnly;
    private final YearSelect yearSelect;
    private final MonthSelect monthSelect;
    private DayTable table;

    public DomDayChooserDiv() {
        this(Day.today(), false);
    }

    public DomDayChooserDiv(Day selectedDay) {
        this(selectedDay, false);
    }

    public DomDayChooserDiv(Day selectedDay, boolean readOnly) {
        this.selectedDay = selectedDay == null ? Day.today() : selectedDay;
        this.readOnly = readOnly;
        this.yearSelect = new YearSelect();
        this.monthSelect = new MonthSelect();
        this.appendChild(new DomActionBar(this.yearSelect, this.monthSelect, new TodayButton()));
        this.table = this.appendChild(new DayTable());
        this.setCssClass(DomElementsCssClasses.DOM_DAY_CHOOSER_DIV);
    }

    public void setDay(Day day) {
        if (day != null) {
            this.selectedDay = day;
            this.updateAll();
        }
    }

    public Day getDay() {
        return this.selectedDay;
    }

    protected void updateDayTable() {
        this.table = this.replaceChild(new DayTable(), this.table);
    }

    private void updateAll() {
        this.yearSelect.setSelectedValue(this.selectedDay.getYear());
        this.monthSelect.setSelectedValue(this.selectedDay.getMonth().getName());
        this.updateDayTable();
    }

    private class YearSelect
    extends AbstractDomValueSelect<Year>
    implements IDomEventHandler {
        private final Range<Year> range = new Range();

        public YearSelect() {
            this.setSelectedValue(DomDayChooserDiv.this.selectedDay.getYear());
            if (DomDayChooserDiv.this.readOnly) {
                this.setEnabled(false);
            } else {
                this.listenToEvent(DomEventType.CHANGE);
            }
        }

        @Override
        protected IDisplayString getValueDisplayString(Year value) {
            return IDisplayString.create((String)value.toString());
        }

        @Override
        protected Integer getValueId(Year value) {
            return value.getAbsoluteIndex();
        }

        @Override
        public void setSelectedValue(Year year) {
            this.updateRange(year);
            super.setSelectedValue(year);
        }

        @Override
        public void handleDOMEvent(IDomEvent event) {
            Year year = (Year)this.getSelectedValue();
            Month month = year.getMonth(DomDayChooserDiv.this.selectedDay.getMonth().getName());
            int index = DomDayChooserDiv.this.selectedDay.getIndexWithinMonth();
            DomDayChooserDiv.this.selectedDay = index <= month.getDays().size() ? (Day)month.getDays().get(index) : month.getLastDayInMonth();
            DomDayChooserDiv.this.updateDayTable();
        }

        private void updateRange(Year year) {
            int min = Math.min(year.getAbsoluteIndex(), 1970);
            int max = Math.max(year.getAbsoluteIndex(), Year.thisYear().getAbsoluteIndex() + 20);
            Year minYear = Year.get((int)min);
            Year maxYear = Year.get((int)max);
            if (!this.range.contains((Comparable)minYear) || !this.range.contains((Comparable)maxYear)) {
                this.range.add((Comparable)minYear);
                this.range.add((Comparable)maxYear);
                this.removeValues();
                Year y = (Year)this.range.getMin();
                while (y.compareTo((DateItem)this.range.getMax()) <= 0) {
                    this.addValue(y);
                    y = (Year)y.getNext();
                }
            }
        }
    }

    private class MonthSelect
    extends AbstractDomValueSelect<MonthName>
    implements IDomEventHandler {
        public MonthSelect() {
            this.addValues(MonthName.values());
            this.setSelectedValue(DomDayChooserDiv.this.selectedDay.getMonth().getName());
            if (DomDayChooserDiv.this.readOnly) {
                this.setEnabled(false);
            } else {
                this.listenToEvent(DomEventType.CHANGE);
            }
        }

        @Override
        protected IDisplayString getValueDisplayString(MonthName value) {
            return value.toDisplay();
        }

        @Override
        protected Integer getValueId(MonthName value) {
            return value.ordinal();
        }

        @Override
        public void handleDOMEvent(IDomEvent event) {
            Year year = DomDayChooserDiv.this.selectedDay.getYear();
            Month month = year.getMonth((MonthName)this.getSelectedValue());
            int index = DomDayChooserDiv.this.selectedDay.getIndexWithinMonth();
            if (index <= month.getDays().size()) {
                DomDayChooserDiv.this.selectedDay = (Day)month.getDays().get(index);
                DomDayChooserDiv.this.updateDayTable();
            } else {
                DomDayChooserDiv.this.selectedDay = (Day)month.getDays().get(month.getDays().size());
                DomDayChooserDiv.this.updateDayTable();
            }
        }
    }

    private class TodayButton
    extends DomButton {
        public TodayButton() {
            this.setIcon(DomElementsImages.CALENDAR_TODAY.getResource());
            this.setLabel((IDisplayString)DomI18n.TODAY);
            this.setClickCallback(() -> DomDayChooserDiv.this.setDay(Day.today()));
        }
    }

    private class DayTable
    extends DomTable {
        public DayTable() {
            DomTHead head = this.appendChild(new DomTHead());
            DomTBody body = this.appendChild(new DomTBody());
            DomRow headerRow = head.appendRow();
            headerRow.appendHeaderCell((IDisplayString)DomI18n.WEEK);
            for (Weekday weekday : Weekday.values()) {
                headerRow.appendHeaderCell(weekday.toShortDisplay());
            }
            Month month = DomDayChooserDiv.this.selectedDay.getMonth();
            Day firstDay = (Day)month.getDays().getFirst();
            Week firstWeek = firstDay.getWeek();
            if (firstDay.getWeekday() == Weekday.MONDAY) {
                firstWeek = (Week)firstWeek.getPrevious();
            }
            Week week = firstWeek;
            int i = 0;
            while (i != 6) {
                DomRow row = body.appendRow();
                row.appendHeaderCell("" + week.getIndexWithinYear());
                for (Weekday weekday : Weekday.values()) {
                    row.appendChild(new DayCell(week.getDay(weekday)));
                }
                ++i;
                week = (Week)week.getNext();
            }
        }

        private class DayCell
        extends DomCell
        implements IDomEventHandler {
            private final Day day;

            public DayCell(Day day) {
                this.day = day;
                this.appendText("" + day.getIndexWithinMonth());
                if (DomDayChooserDiv.this.selectedDay.getMonth().getDays().contains((DateItem)day)) {
                    if (day.isSaturday() || day.isSunday()) {
                        this.setCssClass(DomElementsCssClasses.DOM_DAY_CHOOSER_DIV_WEEKEND);
                    } else {
                        this.setCssClass(DomElementsCssClasses.DOM_DAY_CHOOSER_DIV_WORKDAY);
                    }
                }
                if (day.equals((DateItem)DomDayChooserDiv.this.selectedDay)) {
                    this.addCssClass(DomCssPseudoClasses.SELECTED);
                }
                if (!DomDayChooserDiv.this.readOnly) {
                    this.listenToEvent(DomEventType.CLICK);
                }
            }

            @Override
            public void handleDOMEvent(IDomEvent event) {
                DomDayChooserDiv.this.selectedDay = this.day;
                DomDayChooserDiv.this.updateAll();
            }
        }
    }
}

