/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.time.day;

import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.common.date.DateUtils;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.bar.DomBar;
import com.softicar.platform.dom.elements.time.day.AbstractDomDayPopupButton;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.event.IDomEventHandler;
import com.softicar.platform.dom.input.DomTextInput;

public class DomDayInput
extends DomBar {
    private final DayInput dayInput = this.appendChild(new DayInput());
    private final DayButton dayButton = this.appendChild(new DayButton());

    public DomDayInput() {
        this(Day.today());
    }

    public DomDayInput(Day day) {
        this.setDay(day, false);
        this.addCssClass(DomElementsCssClasses.DOM_DAY_INPUT);
    }

    public DomDayInput setCallback(INullaryVoidFunction callback) {
        this.dayInput.setCallback(callback);
        return this;
    }

    public void disable() {
        this.dayInput.disable();
        this.dayButton.unlistenToEvent(DomEventType.CLICK);
    }

    public Day getDayOrNull() {
        return DateUtils.parseDate(this.dayInput.getValue());
    }

    public Day getDay() {
        Day day = this.getDayOrNull();
        if (day == null) {
            IDisplayString message = DomI18n.THE_TEXT_ARG1_DOES_NOT_REPRESENT_A_VALID_DATE.toDisplay(this.dayInput.getValue()).concat(" ").concat((IDisplayString)DomI18n.VALID_FORMATS).concat(" 2000-12-31, 31.12.2000, 12/31/2000");
            throw new SofticarUserException(message);
        }
        return day;
    }

    public void setDay(Day day) {
        this.setDay(day, true);
    }

    private void setDay(Day day, boolean triggerCallback) {
        if (day != null) {
            this.dayInput.setValue(day.toISOString(), triggerCallback);
            this.dayButton.setDay(day);
        } else {
            this.dayInput.setValue("", triggerCallback);
            this.dayButton.setDay(Day.today());
        }
    }

    public void clear() {
        this.setDay(null);
    }

    public DomTextInput getTextBoxInput() {
        return this.dayInput;
    }

    private class DayInput
    extends DomTextInput
    implements IDomEventHandler {
        private INullaryVoidFunction callback;

        public DayInput() {
            this.setMaxLength(10);
        }

        public void setCallback(INullaryVoidFunction callback) {
            this.callback = callback;
            if (callback != null) {
                this.listenToEvent(DomEventType.CHANGE);
            } else {
                this.unlistenToEvent(DomEventType.CHANGE);
            }
        }

        @Override
        public void handleDOMEvent(IDomEvent event) {
            this.applyCallback();
        }

        @Override
        public void setValue(String value) {
            this.setValue(value, true);
        }

        public void setValue(String value, boolean triggerCallback) {
            super.setValue(value);
            if (triggerCallback) {
                this.applyCallback();
            }
        }

        private void applyCallback() {
            if (this.callback != null) {
                this.callback.apply();
            }
        }
    }

    private class DayButton
    extends AbstractDomDayPopupButton {
        public DayButton() {
            this.setShowLabel(false);
            this.setTabIndex(-1);
            this.setClickCallback(() -> {
                Day day = DomDayInput.this.getDayOrNull();
                if (day != null) {
                    this.setDay(day);
                }
                this.showPopup();
            });
        }

        @Override
        public void handleDayChange() {
            DomDayInput.this.dayInput.setValue(this.getDay().toISOString());
        }
    }
}

