/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.time.day;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.popup.DomPopup;
import com.softicar.platform.dom.elements.time.day.AbstractDomDayPopupButton;
import com.softicar.platform.dom.elements.time.day.DomDayChooserDiv;

class DomDayPopup
extends DomPopup {
    private final DomDayChooserDiv chooser;
    private final AbstractDomDayPopupButton button;
    private Day day;

    public DomDayPopup(DomDayChooserDiv chooser, AbstractDomDayPopupButton button) {
        this.chooser = chooser;
        this.button = button;
        this.setCaption((IDisplayString)DomI18n.DAY_SELECTION);
        this.appendChild(chooser);
        this.appendActionNode(new OkayButton());
        this.appendActionNode(new CancelAndRestoreButton());
        this.setCallbackBeforeShow(this::beforeShow);
    }

    private void beforeShow() {
        this.day = this.chooser.getDay();
        this.setSubCaption(IDisplayString.create((String)this.chooser.getDay().toHumanString()));
    }

    private class OkayButton
    extends DomButton {
        public OkayButton() {
            this.setIcon(DomElementsImages.DIALOG_OKAY.getResource());
            this.setLabel((IDisplayString)DomI18n.OK);
            this.setClickCallback(this::handleClick);
        }

        private void handleClick() {
            DomDayPopup.this.button.setDay(DomDayPopup.this.chooser.getDay());
            DomDayPopup.this.button.handleDayChange();
            DomDayPopup.this.hide();
        }
    }

    private class CancelAndRestoreButton
    extends DomButton {
        public CancelAndRestoreButton() {
            this.setIcon(DomElementsImages.DIALOG_CANCEL.getResource());
            this.setLabel((IDisplayString)DomI18n.CANCEL);
            this.setClickCallback(this::handleClick);
        }

        private void handleClick() {
            DomDayPopup.this.chooser.setDay(DomDayPopup.this.day);
            DomDayPopup.this.hide();
        }
    }
}

