/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.time.daytime;

import com.softicar.platform.common.core.utils.DevNull;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.DayTime;
import com.softicar.platform.common.date.Time;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.bar.DomBar;
import com.softicar.platform.dom.elements.time.DomTimeInput;
import com.softicar.platform.dom.elements.time.day.DomDayInput;

public class DomDayTimeInput
extends DomBar {
    private final DomDayInput dayInput = new DomDayInput();
    private final DomTimeInput timeInput = new DomTimeInput();

    public DomDayTimeInput() {
        this.appendChildren(this.dayInput, this.timeInput);
        this.addCssClass(DomElementsCssClasses.DOM_DAY_TIME_INPUT);
    }

    public DomDayTimeInput disableSeconds() {
        this.timeInput.disableSeconds();
        return this;
    }

    public DomDayInput getDayInput() {
        return this.dayInput;
    }

    public DomTimeInput getTimeInput() {
        return this.timeInput;
    }

    public void setDayTime(DayTime dayTime) {
        this.dayInput.setDay(dayTime != null ? dayTime.getDay() : null);
        this.timeInput.setTime(dayTime != null ? dayTime.getTime() : null);
    }

    public DayTime getDayTime() {
        Time timeOrNull;
        Day dayOrNull = this.getDayInput().getDayOrNull();
        try {
            timeOrNull = this.getTimeInput().getTime();
        }
        catch (Exception exception) {
            DevNull.swallow((Object)exception);
            timeOrNull = null;
        }
        if (dayOrNull != null && timeOrNull != null) {
            int year = dayOrNull.getYear().getAbsoluteIndex();
            int month = dayOrNull.getMonth().getIndexWithinYear();
            int day = dayOrNull.getIndexWithinMonth();
            int hour = timeOrNull.getHour();
            int minute = timeOrNull.getMinute();
            int second = timeOrNull.getSecond();
            return DayTime.fromYMD_HMS((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second);
        }
        return null;
    }

    public void clear() {
        this.dayInput.clear();
        this.timeInput.clear();
    }
}

