/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.wiki;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.ui.wiki.element.IWikiElement;
import com.softicar.platform.common.ui.wiki.element.IWikiParentElement;
import com.softicar.platform.common.ui.wiki.element.IWikiVisitor;
import com.softicar.platform.common.ui.wiki.element.block.WikiDocument;
import com.softicar.platform.common.ui.wiki.element.block.WikiHeadline;
import com.softicar.platform.common.ui.wiki.element.block.WikiList;
import com.softicar.platform.common.ui.wiki.element.block.WikiListItem;
import com.softicar.platform.common.ui.wiki.element.block.WikiListType;
import com.softicar.platform.common.ui.wiki.element.block.WikiParagraph;
import com.softicar.platform.common.ui.wiki.element.block.WikiTable;
import com.softicar.platform.common.ui.wiki.element.block.WikiTableCell;
import com.softicar.platform.common.ui.wiki.element.block.WikiTableRow;
import com.softicar.platform.common.ui.wiki.element.format.WikiBold;
import com.softicar.platform.common.ui.wiki.element.format.WikiItalic;
import com.softicar.platform.common.ui.wiki.element.format.WikiMonospace;
import com.softicar.platform.common.ui.wiki.element.format.WikiUnderline;
import com.softicar.platform.common.ui.wiki.element.inline.WikiLineBreak;
import com.softicar.platform.common.ui.wiki.element.inline.WikiResource;
import com.softicar.platform.common.ui.wiki.element.inline.WikiText;
import com.softicar.platform.common.ui.wiki.element.inline.WikiUrl;
import com.softicar.platform.common.ui.wiki.element.tag.WikiBox;
import com.softicar.platform.common.ui.wiki.element.tag.WikiRawText;
import com.softicar.platform.common.ui.wiki.element.tag.WikiRawTextType;
import com.softicar.platform.common.ui.wiki.parser.WikiParser;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.element.DomSimpleElement;
import com.softicar.platform.dom.element.IDomElement;
import com.softicar.platform.dom.elements.AbstractDomCell;
import com.softicar.platform.dom.elements.DomAnchor;
import com.softicar.platform.dom.elements.DomCell;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.DomHeaderCell;
import com.softicar.platform.dom.elements.DomRow;
import com.softicar.platform.dom.elements.DomTable;
import com.softicar.platform.dom.elements.wiki.DomWikiHeadlines;
import com.softicar.platform.dom.elements.wiki.IWikiBuilderMethods;
import com.softicar.platform.dom.elements.wiki.box.DomWikiBox;
import com.softicar.platform.dom.parent.IDomParentElement;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class DomWikiDivBuilder
implements IWikiBuilderMethods<DomWikiDivBuilder> {
    private final Map<String, IDomElement> elementMap = new TreeMap<String, IDomElement>();
    private final IDomParentElement rootElement;
    private final StringBuilder builder;

    public DomWikiDivBuilder() {
        this(new DomDiv());
    }

    public DomWikiDivBuilder(IDomParentElement rootElement) {
        this.rootElement = rootElement;
        this.builder = new StringBuilder();
    }

    public DomWikiDivBuilder registerElement(String key, IDomElement element) {
        this.elementMap.put(key, element);
        return this;
    }

    @Override
    public DomWikiDivBuilder addText(IDisplayString text) {
        this.builder.append(text);
        return this;
    }

    public DomWikiDivBuilder addEmptyLine() {
        this.builder.append("\n\n");
        return this;
    }

    public DomWikiDivBuilder addLineBreak() {
        this.builder.append("\\\\ ");
        return this;
    }

    public IDomElement build() {
        ElementsBuilder visitor = new ElementsBuilder();
        WikiDocument document = new WikiParser().parse(this.builder.toString());
        document.accept((IWikiVisitor)visitor);
        return this.rootElement;
    }

    public void buildAndAppendTo(IDomParentElement parentElement) {
        parentElement.appendChild(this.build());
    }

    private class ElementsBuilder
    implements IWikiVisitor {
        private final Stack<IDomParentElement> stack = new Stack();

        public void visit(WikiBold bold) {
            this.appendElementAndChildren(DomElementTag.B, (IWikiParentElement)bold);
        }

        public void visit(WikiBox box) {
            DomWikiBox domWikiBox = new DomWikiBox(box.getBoxType());
            this.appendElement(domWikiBox);
            this.appendChildren(domWikiBox.getContentDiv(), (IWikiParentElement)box);
        }

        public void visit(WikiDocument document) {
            this.appendChildren(DomWikiDivBuilder.this.rootElement, (IWikiParentElement)document);
        }

        public void visit(WikiHeadline headline) {
            this.appendElementAndChildren(DomWikiHeadlines.createHeadline(headline), (IWikiParentElement)headline);
        }

        public void visit(WikiItalic italic) {
            this.appendElementAndChildren(DomElementTag.I, (IWikiParentElement)italic);
        }

        public void visit(WikiLineBreak lineBreak) {
            this.stack.peek().appendNewChild(DomElementTag.BR);
        }

        public void visit(WikiList list) {
            DomElementTag tag = list.getListType() == WikiListType.ORDERED ? DomElementTag.OL : DomElementTag.UL;
            this.appendElementAndChildren(tag, (IWikiParentElement)list);
        }

        public void visit(WikiListItem listItem) {
            this.appendElementAndChildren(DomElementTag.LI, (IWikiParentElement)listItem);
        }

        public void visit(WikiMonospace monospace) {
            DomDiv text = new DomDiv();
            text.addCssClass(DomElementsCssClasses.DOM_WIKI_MONOSPACE);
            this.appendElementAndChildren(text, (IWikiParentElement)monospace);
        }

        public void visit(WikiParagraph paragraph) {
            this.appendElementAndChildren(DomElementTag.P, (IWikiParentElement)paragraph);
        }

        public void visit(WikiResource resource) {
            IDomElement element = DomWikiDivBuilder.this.elementMap.get(resource.getUrl());
            if (element != null) {
                this.appendElement(element);
            }
        }

        public void visit(WikiTable table) {
            this.appendElementAndChildren(new DomTable(), (IWikiParentElement)table);
        }

        public void visit(WikiTableCell tableCell) {
            AbstractDomCell cell = tableCell.isHeader() ? new DomHeaderCell() : new DomCell();
            cell.appendText(tableCell.getText());
            this.appendElement(cell);
        }

        public void visit(WikiTableRow tableRow) {
            this.appendElementAndChildren(new DomRow(), (IWikiParentElement)tableRow);
        }

        public void visit(WikiRawText rawText) {
            DomDiv element = new DomDiv();
            element.addCssClass(DomElementsCssClasses.DOM_WIKI_RAW_TEXT);
            if (!rawText.isBlockElement()) {
                element.addCssClass(DomElementsCssClasses.DOM_WIKI_RAW_TEXT_INLINE);
            }
            element.appendText(rawText.getText());
            this.appendElement(element);
            if (rawText.getType() == WikiRawTextType.CODE) {
                element.addCssClass(DomElementsCssClasses.DOM_WIKI_RAW_TEXT_CODE);
                if (rawText.isBlockElement()) {
                    element.addCssClass(DomElementsCssClasses.DOM_WIKI_RAW_TEXT_CODE_BLOCK);
                }
            }
        }

        public void visit(WikiText text) {
            this.stack.peek().appendText(text.getText());
        }

        public void visit(WikiUnderline underline) {
            DomDiv text = new DomDiv();
            text.addCssClass(DomElementsCssClasses.DOM_WIKI_UNDERLINE);
            this.appendElementAndChildren(text, (IWikiParentElement)underline);
        }

        public void visit(WikiUrl url) {
            DomAnchor anchor = new DomAnchor();
            anchor.setHRef(url.getUrl());
            anchor.setAttribute("target", "_blank");
            anchor.appendText(url.getLabel().isEmpty() ? url.getUrl() : url.getLabel());
            this.appendElement(anchor);
        }

        private void appendElementAndChildren(DomElementTag elementTag, IWikiParentElement wikiElement) {
            this.appendElementAndChildren(new DomSimpleElement(elementTag), wikiElement);
        }

        private void appendElementAndChildren(IDomParentElement domElement, IWikiParentElement wikiElement) {
            this.appendElement(domElement);
            this.appendChildren(domElement, wikiElement);
        }

        private void appendElement(IDomElement element) {
            this.stack.peek().appendChild(element);
        }

        private void appendChildren(IDomParentElement domElement, IWikiParentElement wikiElement) {
            this.stack.push(domElement);
            this.visitChildren((IWikiElement)wikiElement);
            this.stack.pop();
        }
    }
}

