/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.wiki;

import com.softicar.platform.common.core.i18n.DisplayString;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.string.Padding;
import com.softicar.platform.common.ui.wiki.element.tag.WikiBoxType;

public interface IWikiBuilderMethods<T extends IWikiBuilderMethods<T>> {
    public T addText(IDisplayString var1);

    default public T addText(String text) {
        return this.addText(IDisplayString.create((String)text));
    }

    default public T addLine(IDisplayString line) {
        return this.addText(line.toString()).addText("\n");
    }

    default public T addHeadline(String level, IDisplayString headline) {
        return this.addLine((IDisplayString)new DisplayString().append(level, new Object[0]).append(headline).append(level, new Object[0]));
    }

    default public T addUnorderedListItem(IDisplayString line) {
        return this.addUnorderedListItem(0, line);
    }

    default public T addUnorderedListItem(int index, IDisplayString line) {
        this.addText(Padding.padLeft((String)"", (char)' ', (int)(2 + index * 2)));
        this.addText("*");
        return this.addLine(line);
    }

    default public T addInlineCode(String code) {
        return this.addText((IDisplayString)new DisplayString().append("<code>", new Object[0]).append(code, new Object[0]).append("</code>", new Object[0]));
    }

    default public T beginCode() {
        return this.addLine(IDisplayString.create((String)"<code>"));
    }

    default public T endCode() {
        return this.addLine(IDisplayString.create((String)"</code>"));
    }

    default public T beginBox(WikiBoxType type) {
        return this.addLine(IDisplayString.create((String)type.name()).enclose("<", ">"));
    }

    default public T endBox(WikiBoxType type) {
        return this.addLine(IDisplayString.create((String)type.name()).enclose("</", ">"));
    }
}

