/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.engine;

import com.softicar.platform.common.io.mime.MimeType;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.common.io.resource.IResourceUrl;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.elements.DomLink;
import com.softicar.platform.dom.engine.DomPopupXAlign;
import com.softicar.platform.dom.engine.DomPopupYAlign;
import com.softicar.platform.dom.engine.IDomExport;
import com.softicar.platform.dom.engine.IDomScriptLibrary;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.timeout.IDomTimeoutNode;
import com.softicar.platform.dom.input.DomSelect;
import com.softicar.platform.dom.input.IDomInputNode;
import com.softicar.platform.dom.input.auto.DomAutoCompleteInputIndicatorMode;
import com.softicar.platform.dom.input.auto.DomAutoCompleteInputValidationMode;
import com.softicar.platform.dom.input.auto.IDomAutoCompleteInput;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.style.ICssClass;
import java.util.Collection;

public interface IDomEngine {
    public void createElement(int var1, DomElementTag var2);

    public void createTextNode(int var1, String var2);

    public void appendChild(IDomNode var1, IDomNode var2);

    public void insertBefore(IDomNode var1, IDomNode var2, IDomNode var3);

    public void removeChild(IDomNode var1, IDomNode var2);

    public void replaceChild(IDomNode var1, IDomNode var2, IDomNode var3);

    public void setNodeAttribute(IDomNode var1, IDomAttribute var2);

    public void unsetNodeAttribute(IDomNode var1, String var2);

    public void setNodeStyle(IDomNode var1, String var2, String var3);

    public void unsetNodeStyle(IDomNode var1, String var2);

    public void setMaximumZIndex(IDomNode var1);

    public void listenToEvent(IDomNode var1, DomEventType var2);

    public void unlistenToEvent(IDomNode var1, DomEventType var2);

    public void setFireOnKeyUp(IDomNode var1, DomEventType var2, boolean var3);

    public void setPreventDefaultBehavior(IDomNode var1, DomEventType var2, boolean var3);

    public void stopPropagation(IDomNode var1, String var2);

    default public void setCssClassOnKeyDown(IDomNode node, DomEventType eventType, Collection<ICssClass> cssClasses) {
        this.setCssClassOnKeyDown(node, eventType, node, cssClasses);
    }

    public void setCssClassOnKeyDown(IDomNode var1, DomEventType var2, IDomNode var3, Collection<ICssClass> var4);

    public void setClickTargetForEventDelegation(IDomNode var1, DomEventType var2, IDomNode var3);

    public void unsetClickTargetForEventDelegation(IDomNode var1, DomEventType var2);

    public void scheduleTimeout(IDomTimeoutNode var1, Double var2);

    public void clearLastScheduledTimeout();

    public void makeDraggable(IDomNode var1, IDomNode var2);

    public void enableAutoComplete(IDomAutoCompleteInput<?> var1);

    public void setAutoCompleteInputInvalid(IDomAutoCompleteInput<?> var1);

    public void setAutoCompleteInputMandatory(IDomAutoCompleteInput<?> var1, boolean var2);

    public void setAutoCompleteValidationMode(IDomAutoCompleteInput<?> var1, DomAutoCompleteInputValidationMode var2);

    public void setAutoCompleteIndicatorMode(IDomAutoCompleteInput<?> var1, DomAutoCompleteInputIndicatorMode var2);

    public void setAutoCompleteEnabled(IDomAutoCompleteInput<?> var1, boolean var2);

    public IDomExport createExport();

    public void blur(IDomNode var1);

    public void focus(IDomNode var1);

    public void select(IDomNode var1);

    public void insertAtCaret(IDomInputNode var1, String var2);

    public void moveCaretToPosition(IDomInputNode var1, int var2);

    public void showPopup(IDomNode var1, int var2, int var3, DomPopupXAlign var4, DomPopupYAlign var5);

    public void hidePopup(IDomNode var1);

    public void loadScriptLibrary(IDomScriptLibrary var1);

    public void executeScriptCode(String var1);

    public void resetForm(IDomNode var1);

    public void submitForm(IDomNode var1);

    public void submitFormOnChange(IDomNode var1, IDomNode var2);

    public void trapTabFocus(IDomNode var1);

    public void setWorkingIndicatorEnabled(boolean var1);

    public void approveNodeValues();

    public void setSelectedOptions(DomSelect<?> var1, Collection<Integer> var2);

    public IResourceUrl getResourceUrl(IResource var1);

    public void pushBrowserHistoryState(String var1, String var2);

    public void reloadPage();

    public void setReloadPageOnClick(IDomNode var1);

    public void registerResourceLink(IResource var1, DomLink.Relationship var2, MimeType var3);

    default public void registerCssResourceLink(IResource resource) {
        this.registerResourceLink(resource, DomLink.Relationship.STYLESHEET, MimeType.TEXT_CSS);
    }
}

