/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.event;

import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomAutoEventHandler;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.node.IDomNode;
import java.util.function.BiConsumer;

public class DomEventDelegator<H extends IDomAutoEventHandler> {
    private final DomEventType type;
    private final Class<H> handlerClass;
    private final BiConsumer<H, IDomEvent> consumer;

    public DomEventDelegator(DomEventType type, Class<H> handlerClass, BiConsumer<H, IDomEvent> consumer) {
        this.type = type;
        this.handlerClass = handlerClass;
        this.consumer = consumer;
    }

    public boolean enableEventListening(IDomNode node) {
        if (this.handlerClass.isInstance(node)) {
            node.getDomEngine().listenToEvent(node, this.type);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IDomNode node, IDomEvent event) {
        if (this.handlerClass.isInstance(node)) {
            this.consumer.accept((IDomAutoEventHandler)this.handlerClass.cast(node), event);
            return true;
        }
        return false;
    }
}

