/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.input;

import com.softicar.platform.common.container.map.MapFactory;
import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.input.DomOption;
import com.softicar.platform.dom.input.IDomEnableable;
import com.softicar.platform.dom.input.IDomFocusable;
import com.softicar.platform.dom.parent.DomParentElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DomSelect<O extends DomOption>
extends DomParentElement
implements IDomEnableable,
IDomFocusable {
    private final Map<Integer, O> selectedOptions = MapFactory.createTreeMap();

    @Override
    public final DomElementTag getTag() {
        return DomElementTag.SELECT;
    }

    public final void setMultiple(boolean multiple) {
        this.setAttribute("multiple", multiple);
    }

    public final boolean isMultiple() {
        return this.getAttributeValue("multiple").map(value -> value.equals("true")).orElse(false);
    }

    public final O getSelectedOption() {
        if (this.selectedOptions.isEmpty() && !this.isMultiple() && this.getChildCount() > 0) {
            return this.getOption(0);
        }
        if (this.selectedOptions.size() == 1) {
            return (O)((DomOption)this.selectedOptions.values().iterator().next());
        }
        if (this.selectedOptions.size() > 1) {
            throw new SofticarUserException(DomI18n.MULTIPLE_OPTIONS_WERE_SELECTED.concatSentence((IDisplayString)DomI18n.ONLY_ONE_OPTION_MAY_BE_SELECTED));
        }
        return null;
    }

    public final void setSelectedOption(O option) {
        if (option == null) {
            throw new SofticarUserException((IDisplayString)DomI18n.AN_NONEXISTENT_OPTION_WAS_SELECTED);
        }
        this.setSelectedOptions(Collections.singletonList(option));
    }

    public final void setSelectedOptions_noJS(String selectedOptions) {
        this.selectedOptions.clear();
        if (!selectedOptions.equals("")) {
            for (String optionId : selectedOptions.split(",")) {
                DomOption option = (DomOption)this.getDomDocument().getNode(optionId);
                if (option == null) {
                    throw new SofticarUserException(DomI18n.THE_SELECTED_OPTION_ARG1_VANISHED.toDisplay((Object)optionId).concat(" ").concat((IDisplayString)DomI18n.PLEASE_TRY_AGAIN));
                }
                this.selectedOptions.put(option.getNodeId(), option);
            }
        }
    }

    protected final O getOption(int index) {
        return (O)((DomOption)this.getChild(index));
    }

    protected final Collection<O> getSelectedOptions() {
        return this.selectedOptions.values();
    }

    protected final void setSelectedOptions(Collection<O> selectedOptions) {
        this.selectedOptions.clear();
        for (DomOption option : selectedOptions.stream().filter(Objects::nonNull).collect(Collectors.toList())) {
            this.selectedOptions.put(option.getNodeId(), option);
        }
        this.getDomEngine().setSelectedOptions(this, this.selectedOptions.keySet());
    }
}

