/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.input;

import com.softicar.platform.dom.input.IDomValueBasedInputNode;
import java.util.Optional;

public interface IDomStringInputNode
extends IDomValueBasedInputNode<String> {
    @Override
    default public void setValue(String value) {
        this.setAttribute("value", value);
    }

    @Override
    default public String getValue() {
        return this.getAttributeValue("value").orElse(null);
    }

    default public void clearValue() {
        this.setValue("");
    }

    default public void trimValue() {
        Optional.ofNullable(this.getValue()).map(String::trim).ifPresent(this::setValue);
    }

    default public String getTextOrNull() {
        if (this.getValue() != null) {
            this.trimValue();
            if (!this.getValue().isEmpty()) {
                return this.getValue();
            }
            return null;
        }
        return null;
    }

    default public void insertAtCaret(String text) {
        this.getDomEngine().insertAtCaret(this, text);
    }

    default public void moveCaretToPosition(int position) {
        this.getDomEngine().moveCaretToPosition(this, position);
    }

    default public void select() {
        this.getDomEngine().select(this);
    }
}

