/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.node;

import com.softicar.platform.dom.attribute.DomAttribute;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.attribute.IDomAttributeMap;
import com.softicar.platform.dom.attribute.IDomAttributeRegistry;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.node.IDomNodeAccessor;
import com.softicar.platform.dom.parent.IDomParentElement;
import java.util.Optional;

abstract class AbstractDomNode
implements IDomNode {
    private final int nodeId;
    private IDomParentElement parent;
    private IDomAttributeMap attributeMap;

    public AbstractDomNode(IDomDocument document) {
        this.nodeId = document.registerNode(this);
        this.attributeMap = document.getAttributeRegistry().getEmptyMap();
    }

    @Override
    public final int getNodeId() {
        return this.nodeId;
    }

    @Override
    public final IDomParentElement getParent() {
        return this.parent;
    }

    @Override
    public final void disappend() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    @Override
    public final IDomDocument getDomDocument() {
        return this.attributeMap.getDomDocument();
    }

    @Override
    public IDomNodeAccessor getAccessor() {
        return new Accessor(this);
    }

    @Override
    public final Iterable<IDomAttribute> getAttributes() {
        return this.attributeMap.values();
    }

    @Override
    public final IDomAttribute getAttribute(String name) {
        IDomAttribute attribute = this.attributeMap.getAttribute(name);
        return attribute != null ? attribute : new DomAttribute(name, null, false);
    }

    @Override
    public final Optional<String> getAttributeValue(String name) {
        return Optional.ofNullable(this.attributeMap.getAttribute(name)).map(attribute -> attribute.getValue());
    }

    @Override
    public final IDomNode setAttribute(IDomAttribute attribute) {
        this.setAttributeInMap(attribute);
        this.getDomDocument().getEngine().setNodeAttribute(this, attribute);
        return this;
    }

    @Override
    public final IDomNode setAttribute(String name, int value) {
        return this.setAttribute(name, "" + value, false);
    }

    @Override
    public final IDomNode setAttribute(String name, boolean value) {
        return this.setAttribute(name, value ? "true" : "false", false);
    }

    @Override
    public final IDomNode setAttribute(String name, String value) {
        if (value != null) {
            return this.setAttribute(name, value, true);
        }
        return this.setAttribute(name, value, false);
    }

    @Override
    public final IDomNode setAttribute(String name, String value, boolean quote) {
        return this.setAttribute(new DomAttribute(name, value, quote));
    }

    @Override
    public final IDomNode unsetAttribute(String name) {
        return this.setAttribute(new DomAttribute(name, null, false));
    }

    void setParent(IDomParentElement parent) {
        this.parent = parent;
    }

    void setAttributeInMap(IDomAttribute attribute) {
        this.attributeMap = attribute.getValue() != null ? this.getAttributeRegistry().put(this.attributeMap, attribute) : this.getAttributeRegistry().remove(this.attributeMap, attribute.getName());
    }

    private IDomAttributeRegistry getAttributeRegistry() {
        return this.attributeMap.getAttributeRegistry();
    }

    private class Accessor
    implements IDomNodeAccessor {
        private final AbstractDomNode node;

        public Accessor(AbstractDomNode node) {
            this.node = node;
        }

        @Override
        public void setParent(IDomParentElement parent) {
            this.node.setParent(parent);
        }

        @Override
        public void setAttributeInMap(IDomAttribute attribute) {
            this.node.setAttributeInMap(attribute);
        }

        @Override
        public void setAttributeInMap(String name, boolean value) {
            this.setAttributeInMap(name, value ? "true" : "false", false);
        }

        @Override
        public void setAttributeInMap(String name, String value) {
            this.setAttributeInMap(name, value, true);
        }

        @Override
        public void setAttributeInMap(String name, String value, boolean quote) {
            this.setAttributeInMap(new DomAttribute(name, value, quote));
        }
    }
}

