/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.node;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.document.CurrentDomDocument;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.elements.dialog.DomModalAlertPopup;
import com.softicar.platform.dom.elements.dialog.DomModalConfirmPopup;
import com.softicar.platform.dom.elements.dialog.DomModalPromptPopup;
import com.softicar.platform.dom.input.IDomListeningNode;
import com.softicar.platform.dom.node.AbstractDomNode;
import java.io.IOException;
import java.util.function.Consumer;

public abstract class DomNode
extends AbstractDomNode
implements IDomListeningNode {
    protected DomNode() {
        super(CurrentDomDocument.get());
    }

    protected DomNode(IDomDocument document) {
        super(document);
    }

    @Override
    public final void executeAlert(IDisplayString message) {
        new DomModalAlertPopup(message).show();
    }

    @Override
    public void executeConfirm(INullaryVoidFunction confirmHandler, IDisplayString message) {
        new DomModalConfirmPopup(confirmHandler, message).show();
    }

    @Override
    public void executePrompt(Consumer<String> promptHandler, IDisplayString message, String defaultValue) {
        new DomModalPromptPopup(promptHandler, message, defaultValue).show();
    }

    protected void buildAttributesHTML(Appendable out) throws IOException {
        out.append(" id='n" + this.getNodeId() + "'");
        for (IDomAttribute attribute : this.getAttributes()) {
            out.append(" ");
            out.append(attribute.getName() + "=" + attribute.getValue_JS());
        }
    }

    @Override
    public abstract void buildHtml(Appendable var1) throws IOException;
}

