/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.node;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.engine.IDomEngine;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.node.IDomNodeAccessor;
import com.softicar.platform.dom.parent.IDomParentElement;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;

public interface IDomNode {
    public int getNodeId();

    default public String getNodeIdString() {
        return "n" + this.getNodeId();
    }

    public IDomParentElement getParent();

    public void disappend();

    public IDomDocument getDomDocument();

    default public IDomEvent getCurrentEvent() {
        return this.getDomDocument().getCurrentEvent();
    }

    public IDomNodeAccessor getAccessor();

    default public IDomEngine getDomEngine() {
        return this.getDomDocument().getEngine();
    }

    public Iterable<IDomAttribute> getAttributes();

    public IDomAttribute getAttribute(String var1);

    public Optional<String> getAttributeValue(String var1);

    public IDomNode setAttribute(IDomAttribute var1);

    public IDomNode setAttribute(String var1, int var2);

    public IDomNode setAttribute(String var1, boolean var2);

    public IDomNode setAttribute(String var1, String var2);

    public IDomNode setAttribute(String var1, String var2, boolean var3);

    public IDomNode unsetAttribute(String var1);

    default public IDomNode setMarker(IStaticObject marker) {
        this.getDomDocument().setMarker(this, marker);
        return this;
    }

    default public boolean hasMarker(IStaticObject ... markers) {
        return this.getDomDocument().hasMarker(this, markers);
    }

    public void executeAlert(IDisplayString var1);

    public void executeConfirm(INullaryVoidFunction var1, IDisplayString var2);

    public void executePrompt(Consumer<String> var1, IDisplayString var2, String var3);

    public void buildHtml(Appendable var1) throws IOException;
}

