/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.node.tree;

import com.softicar.platform.common.container.iterable.recurse.RecurseIterable;
import com.softicar.platform.common.core.utils.CastUtils;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.parent.IDomParentElement;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DomNodeTree {
    private final IDomNode rootNode;

    public DomNodeTree(IDomNode rootNode) {
        this.rootNode = rootNode;
    }

    public Stream<IDomNode> stream() {
        return StreamSupport.stream(this.getRecursiveIterable().spliterator(), false);
    }

    public <T> Stream<T> stream(Class<T> targetClass) {
        return this.stream().filter(targetClass::isInstance).map(targetClass::cast);
    }

    private Iterable<IDomNode> getRecursiveIterable() {
        return new RecurseIterable(Collections.singleton(this.rootNode), this::getChildren);
    }

    private Collection<IDomNode> getChildren(IDomNode node) {
        return CastUtils.tryCast((Object)node, IDomParentElement.class).map(IDomParentElement::getChildren).orElse(Collections.emptyList());
    }
}

