/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.parent;

import com.softicar.platform.common.container.list.ListFactory;
import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.common.core.utils.CastUtils;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.element.DomElement;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.element.DomSimpleElement;
import com.softicar.platform.dom.engine.IDomEngine;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.parent.IDomParentElement;
import com.softicar.platform.dom.parent.RecursiveEnabling;
import com.softicar.platform.dom.parent.RecursiveFocusing;
import com.softicar.platform.dom.text.DomTextNode;
import com.softicar.platform.dom.text.IDomTextNode;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class DomParentElement
extends DomElement
implements IDomParentElement {
    private Object children;

    protected DomParentElement() {
        super(true);
    }

    protected DomParentElement(boolean doCreate) {
        super(doCreate);
    }

    protected DomParentElement(IDomDocument document, boolean doCreate) {
        super(document, doCreate);
    }

    @Override
    public <T extends IDomNode> T insertAt(T child, int index) {
        int n = this.getChildCount();
        if (child.getParent() != null) {
            throw new SofticarDeveloperException("Trying to add a child that already has a parent.");
        }
        if (index < 0 || index > n) {
            throw new SofticarDeveloperException("Index %s out of range [0, %s] while inserting child node.", new Object[]{index, n});
        }
        List<Object> list = null;
        if (this.children == null) {
            this.children = child;
        } else {
            if (this.children instanceof IDomNode) {
                list = ListFactory.createArrayList((int)2);
                list.add((IDomNode)this.children);
                this.children = list;
            } else {
                list = this.castChildrenToList();
            }
            list.add(index, child);
        }
        child.getAccessor().setParent(this);
        if (index == n) {
            this.getDomEngine().appendChild(this, child);
        } else if (list != null) {
            this.getDomEngine().insertBefore(this, child, (IDomNode)list.get(index + 1));
        } else {
            throw new SofticarDeveloperException("Internal program error while inserting child.");
        }
        return child;
    }

    @Override
    public <T extends IDomNode> T replaceChild(T newChild, IDomNode oldChild) {
        if (newChild.getParent() != null) {
            throw new SofticarDeveloperException("Tried to append child node that already has a parent.");
        }
        if (oldChild.getParent() != this) {
            throw new SofticarDeveloperException("Tried to replace child node (ID %d) that is not a child of this node", new Object[]{oldChild.getNodeId()});
        }
        int index = this.getChildIndex(oldChild);
        if (this.children instanceof IDomNode) {
            this.children = newChild;
        } else {
            this.castChildrenToList().set(index, newChild);
        }
        oldChild.getAccessor().setParent(null);
        newChild.getAccessor().setParent(this);
        this.getDomEngine().replaceChild(this, newChild, oldChild);
        return newChild;
    }

    @Override
    public void removeChild(IDomNode child) {
        if (child.getParent() != this) {
            throw new SofticarDeveloperException("Tried to remove child node that is not a child of this node.");
        }
        if (this.children == child) {
            this.children = null;
            child.getAccessor().setParent(null);
        } else {
            Iterator<IDomNode> it = this.castChildrenToList().iterator();
            while (it.hasNext()) {
                IDomNode node = it.next();
                if (node != child) continue;
                child.getAccessor().setParent(null);
                it.remove();
                break;
            }
            if (child.getParent() != null) {
                throw new SofticarDeveloperException("Failed to find child in dom element.");
            }
        }
        this.getDomEngine().removeChild(this, child);
    }

    @Override
    public void removeChildren() {
        if (this.children != null) {
            IDomEngine engine = this.getDomEngine();
            if (this.children instanceof IDomNode) {
                IDomNode child = (IDomNode)this.children;
                child.getAccessor().setParent(null);
                engine.removeChild(this, child);
            } else {
                for (IDomNode child : this.castChildrenToList()) {
                    child.getAccessor().setParent(null);
                    engine.removeChild(this, child);
                }
            }
            this.children = null;
        }
    }

    @Override
    public <T extends IDomNode> T appendChild(T child) {
        return this.insertAt(child, this.getChildCount());
    }

    @Override
    public void appendChild(Object child) {
        if (child instanceof IDomNode) {
            this.appendChild((IDomNode)child);
        } else if (child instanceof String) {
            this.appendText((String)child);
        } else {
            this.appendText("" + child);
        }
    }

    @Override
    public void appendChildren(Object ... children) {
        for (Object child : children) {
            this.appendChild(child);
        }
    }

    @Override
    public <T extends IDomNode> T prependChild(T child) {
        return this.insertAt(child, 0);
    }

    @Override
    public <T extends IDomNode> T insertBefore(T child, IDomNode otherChild) {
        return this.insertAt(child, this.getChildIndex(otherChild));
    }

    @Override
    public <T extends IDomNode> T insertAfter(T child, IDomNode otherChild) {
        return this.insertAt(child, this.getChildIndex(otherChild) + 1);
    }

    @Override
    public void removeChildrenAfter(IDomNode child) {
        int index = this.getChildIndex(child);
        for (int i = this.getChildCount() - 1; i > index; --i) {
            this.removeChild(this.getChild(i));
        }
    }

    @Override
    public boolean hasChild(IDomNode child) {
        return child.getParent() == this;
    }

    @Override
    public IDomTextNode appendText(String text) {
        return this.appendChild((IDomNode)DomTextNode.create(text));
    }

    @Override
    public IDomTextNode prependText(String text) {
        return this.prependChild(DomTextNode.create(text));
    }

    @Override
    public IDomTextNode appendText(String text, Object ... args) {
        return this.appendText(String.format(text, args));
    }

    @Override
    public DomSimpleElement appendNewChild(DomElementTag tag) {
        return this.appendChild((IDomNode)new DomSimpleElement(tag));
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof IDomNode) {
            return 1;
        }
        return this.castChildrenToList().size();
    }

    @Override
    public int getChildIndex(IDomNode child) {
        int i = 0;
        for (IDomNode node : this.getChildren()) {
            if (node == child) {
                return i;
            }
            ++i;
        }
        throw new SofticarDeveloperException("Failed to find child in dom element.");
    }

    @Override
    public IDomNode getChild(int index) {
        return this.getChildren().get(index);
    }

    @Override
    public List<IDomNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        if (this.children instanceof IDomNode) {
            return Collections.singletonList((IDomNode)this.children);
        }
        return this.castChildrenToList();
    }

    @Override
    public void disableAllChildren() {
        RecursiveEnabling.setEnabled(this, false);
    }

    @Override
    public void setEnabledRecursively(boolean enabled) {
        RecursiveEnabling.setEnabled(this, enabled);
    }

    @Override
    public void focusFirst() {
        RecursiveFocusing.focusFirst(this);
    }

    protected void buildChildrenHTML(Appendable out) throws IOException {
        for (IDomNode child : this.getChildren()) {
            child.buildHtml(out);
        }
    }

    @Override
    public void buildHtml(Appendable out) throws IOException {
        out.append("<" + this.getTag().getName());
        this.buildAttributesHTML(out);
        if (this.getTag().getBlockType() == DomElement.HierarchyType.PARENT) {
            out.append(">");
            this.buildChildrenHTML(out);
            out.append("</" + this.getTag().getName() + ">");
        } else {
            out.append("/>");
        }
    }

    private List<IDomNode> castChildrenToList() {
        return (List)CastUtils.cast((Object)this.children);
    }
}

