/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.refresh.bus;

import com.softicar.platform.dom.refresh.bus.DomRefreshBusEvent;
import com.softicar.platform.dom.refresh.bus.IDomRefreshBus;
import com.softicar.platform.dom.refresh.bus.IDomRefreshBusListener;
import java.util.Map;
import java.util.WeakHashMap;

public class DomRefreshBus
implements IDomRefreshBus {
    private final Map<IDomRefreshBusListener, Boolean> listeners = new WeakHashMap<IDomRefreshBusListener, Boolean>();
    private final Map<IDomRefreshBusListener, Boolean> queue = new WeakHashMap<IDomRefreshBusListener, Boolean>();
    private DomRefreshBusEvent refreshEvent;

    public DomRefreshBus() {
        this.initializeNewEvent();
    }

    @Override
    public IDomRefreshBus addListener(IDomRefreshBusListener listener) {
        this.queue.put(listener, true);
        return this;
    }

    @Override
    public IDomRefreshBus removeListener(IDomRefreshBusListener listener) {
        this.queue.put(listener, false);
        return this;
    }

    @Override
    public IDomRefreshBus setChanged(Object object) {
        this.refreshEvent.setChanged(object);
        return this;
    }

    @Override
    public IDomRefreshBus setAllChanged(Class<?> classes) {
        this.refreshEvent.setAllChanged(classes);
        return this;
    }

    @Override
    public IDomRefreshBus setAllChanged() {
        this.refreshEvent.setAllChanged();
        return this;
    }

    @Override
    public IDomRefreshBus submitEvent() {
        if (!this.refreshEvent.isEmpty()) {
            this.submitQueue();
            this.listeners.keySet().forEach(listener -> listener.invalidateCachedData(this.refreshEvent));
            this.listeners.keySet().forEach(listener -> listener.refresh(this.refreshEvent));
            this.initializeNewEvent();
        }
        return this;
    }

    @Override
    public IDomRefreshBus discardEvent() {
        this.initializeNewEvent();
        return this;
    }

    private void initializeNewEvent() {
        this.refreshEvent = new DomRefreshBusEvent();
    }

    private void submitQueue() {
        for (Map.Entry<IDomRefreshBusListener, Boolean> entry : this.queue.entrySet()) {
            if (entry.getValue().booleanValue()) {
                this.listeners.put(entry.getKey(), true);
                continue;
            }
            this.listeners.remove(entry.getKey());
        }
        this.queue.clear();
    }
}

