/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.refresh.bus;

import com.softicar.platform.common.container.map.identity.IdentityHashList;
import com.softicar.platform.dom.refresh.bus.IDomRefreshBusEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

class DomRefreshBusEvent
implements IDomRefreshBusEvent {
    private final Collection<Object> objects = new IdentityHashList();
    private final Set<Class<?>> classes = new HashSet();
    private boolean allChanged = false;

    @Override
    public boolean isChanged(Object object) {
        if (this.allChanged) {
            return true;
        }
        if (this.objects.contains(object)) {
            return true;
        }
        return this.classes.contains(object.getClass());
    }

    @Override
    public <T> Collection<? extends T> getChangedObjects(Class<T> objectClass) {
        return this.objects.stream().filter(objectClass::isInstance).map(objectClass::cast).collect(Collectors.toList());
    }

    @Override
    public boolean isAnyObjectChanged(Collection<Class<?>> classes) {
        if (this.allChanged) {
            return true;
        }
        if (DomRefreshBusEvent.isAnyMatch(this.classes, classes)) {
            return true;
        }
        return this.objects.stream().anyMatch(object -> DomRefreshBusEvent.isAnyMatch(object, classes));
    }

    @Override
    public boolean isAllChanged() {
        return this.allChanged;
    }

    protected void setChanged(Object object) {
        this.objects.add(object);
    }

    protected void setAllChanged(Class<?> classes) {
        this.classes.add(classes);
    }

    protected void setAllChanged() {
        this.allChanged = true;
    }

    protected boolean isEmpty() {
        return this.objects.isEmpty() && this.classes.isEmpty() && !this.allChanged;
    }

    private static boolean isAnyMatch(Set<Class<?>> setOfClasses, Collection<Class<?>> classes) {
        return classes.stream().anyMatch(setOfClasses::contains);
    }

    private static boolean isAnyMatch(Object object, Collection<Class<?>> classes) {
        return classes.stream().anyMatch(objectClass -> objectClass.isInstance(object));
    }
}

