/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.resource.preprocessed;

import com.softicar.platform.common.io.resource.key.IResourceKey;
import com.softicar.platform.common.io.resource.key.ResourceKey;
import com.softicar.platform.dom.resource.preprocessed.DomCssPreprocessorException;
import java.util.Objects;

class DomCssPreprocessorClasspathResourceKeyFactory {
    DomCssPreprocessorClasspathResourceKeyFactory() {
    }

    public IResourceKey create(String absolutePath) {
        this.validateAbsolutePath(absolutePath);
        String filename = absolutePath.replaceFirst(".*/", "");
        String packageName = absolutePath.substring(1, absolutePath.lastIndexOf("/")).replaceAll("/", ".");
        return new ResourceKey(packageName, filename);
    }

    private void validateAbsolutePath(String absolutePath) {
        Objects.requireNonNull(absolutePath);
        if (!absolutePath.startsWith("/")) {
            throw new DomCssPreprocessorException("'%s' is not an absolute path.".formatted(absolutePath));
        }
    }
}

