/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.resource.preprocessed;

import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.common.io.resource.key.IResourceKey;
import com.softicar.platform.dom.document.CurrentDomDocument;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.resource.preprocessed.DomCssPreprocessorClasspathResourceKeyFactory;
import com.softicar.platform.dom.resource.preprocessed.DomCssPreprocessorException;
import com.softicar.platform.dom.resource.set.IDomResourceSet;
import java.util.Objects;

class DomCssPreprocessorResourceUrlFactory {
    private final IDomResourceSet resourceSet;

    public DomCssPreprocessorResourceUrlFactory(IDomResourceSet resourceSet) {
        this.resourceSet = Objects.requireNonNull(resourceSet);
    }

    public String create(String absolutePath) {
        IResourceKey resourceKey = new DomCssPreprocessorClasspathResourceKeyFactory().create(absolutePath);
        IResource resource = this.resourceSet.getResource(resourceKey).orElseThrow(() -> new DomCssPreprocessorException("Could not retrieve resource for '%s'.".formatted(absolutePath)));
        return this.createResourceUrl(resource);
    }

    private String createResourceUrl(IResource resource) {
        IDomDocument document = CurrentDomDocument.get();
        if (document != null) {
            try {
                return document.getEngine().getResourceUrl(resource).toString();
            }
            catch (Exception exception) {
                throw new DomCssPreprocessorException("Failed to create a resource URL.", exception);
            }
        }
        return "";
    }
}

