/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.resource.set;

import com.softicar.platform.common.core.constant.container.field.ConstantContainerFieldExtractor;
import com.softicar.platform.common.core.constant.container.field.IConstantContainerField;
import com.softicar.platform.common.core.utils.CastUtils;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.common.io.resource.container.ResourceSupplierContainer;
import com.softicar.platform.common.io.resource.key.IResourceKey;
import com.softicar.platform.common.io.resource.key.ResourceKey;
import com.softicar.platform.common.io.resource.static_.IStaticResourceSupplier;
import com.softicar.platform.common.io.resource.supplier.IResourceSupplier;
import com.softicar.platform.dom.resource.set.IDomResourceSet;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultDomResourceSet
implements IDomResourceSet {
    private static final IDomResourceSet SINGLETON = new DefaultDomResourceSet();
    private final Map<IResourceKey, IResource> resources = new HashMap<IResourceKey, IResource>();

    public static IDomResourceSet getInstance() {
        return SINGLETON;
    }

    private DefaultDomResourceSet() {
        this.initialize();
    }

    @Override
    public Optional<IResource> getResource(IResourceKey resourceKey) {
        return Optional.ofNullable(this.resources.get(resourceKey));
    }

    private void initialize() {
        for (Class<?> containerClass : this.loadContainerClasses()) {
            for (IConstantContainerField<IResourceSupplier> field : this.extractFields(containerClass)) {
                CastUtils.tryCast((Object)field.getValue(), IStaticResourceSupplier.class).map(IStaticResourceSupplier::getStaticResource).ifPresent(resource -> this.addResource(containerClass, (IResource)resource));
            }
        }
    }

    private List<Class<?>> loadContainerClasses() {
        try (ScanResult scanResult = new ClassGraph().ignoreParentClassLoaders().enableAnnotationInfo().scan();){
            List list = scanResult.getClassesWithAnnotation(ResourceSupplierContainer.class.getCanonicalName()).loadClasses();
            return list;
        }
    }

    private Collection<IConstantContainerField<IResourceSupplier>> extractFields(Class<?> containerClass) {
        return new ConstantContainerFieldExtractor(containerClass, IResourceSupplier.class).extractFields();
    }

    private void addResource(Class<?> containerClass, IResource resource) {
        resource.getFilename().ifPresent(filename -> this.resources.put((IResourceKey)new ResourceKey(containerClass, filename), resource));
    }
}

