/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.resource.set;

import com.softicar.platform.common.io.mime.MimeType;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.common.io.resource.key.IResourceKey;
import com.softicar.platform.dom.resource.preprocessed.DomPreprocessedCssResource;
import com.softicar.platform.dom.resource.set.DefaultDomResourceSet;
import com.softicar.platform.dom.resource.set.DomBasicResourceSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DomResourceSet
extends DomBasicResourceSet {
    private final Map<IResourceKey, IResource> preprocessedResources = new HashMap<IResourceKey, IResource>();

    @Override
    public Optional<IResource> getResource(IResourceKey resourceKey) {
        return super.getResource(resourceKey).or(() -> DefaultDomResourceSet.getInstance().getResource(resourceKey)).map(resource -> this.preprocess((IResource)resource, resourceKey));
    }

    private IResource preprocess(IResource resource, IResourceKey resourceKey) {
        if (resource.getMimeType().equals(MimeType.TEXT_CSS)) {
            return this.preprocessedResources.computeIfAbsent(resourceKey, dummy -> new DomPreprocessedCssResource(resource, this));
        }
        return resource;
    }
}

