/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.resource.set.loader;

import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.common.io.resource.file.FileResource;
import com.softicar.platform.common.io.resource.key.IResourceKey;
import com.softicar.platform.common.io.resource.key.ResourceKey;
import com.softicar.platform.dom.resource.set.DomResourceSet;
import java.io.File;
import java.util.Objects;
import java.util.stream.Stream;

public class DomResourceSetFromFolderLoader {
    private final File rootFolder;
    private DomResourceSet resourceSet;

    public DomResourceSetFromFolderLoader(File rootFolder) {
        this.rootFolder = Objects.requireNonNull(rootFolder);
    }

    public DomResourceSet load() {
        this.resourceSet = new DomResourceSet();
        Stream.of(this.rootFolder.listFiles()).filter(File::isDirectory).forEach(this::addPackageFolder);
        return this.resourceSet;
    }

    private void addPackageFolder(File packageFolder) {
        Stream.of(packageFolder.listFiles()).forEach(this::addResourceFile);
    }

    private void addResourceFile(File resourceFile) {
        this.resourceSet.put((IResourceKey)this.getResourceKey(resourceFile), (IResource)new FileResource(resourceFile));
    }

    private ResourceKey getResourceKey(File resourceFile) {
        String packageName = resourceFile.getParentFile().getName();
        return new ResourceKey(packageName, resourceFile.getName());
    }
}

