/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.styles;

import com.softicar.platform.common.ui.color.IColor;
import com.softicar.platform.dom.style.CssStyle;
import com.softicar.platform.dom.style.ICssLength;
import com.softicar.platform.dom.style.ICssStyle;
import com.softicar.platform.dom.style.ICssStyleAttribute;
import com.softicar.platform.dom.styles.CssBoxShadowType;

public class CssBoxShadow
implements ICssStyleAttribute {
    private final ICssLength x;
    private final ICssLength y;
    private final ICssLength blur;
    private final ICssLength spread;
    private final IColor color;
    private final CssBoxShadowType type;

    public CssBoxShadow(ICssLength x, ICssLength y, IColor color) {
        this(x, y, ICssLength.ZERO, ICssLength.ZERO, color, CssBoxShadowType.NORMAL);
    }

    public CssBoxShadow(ICssLength x, ICssLength y, ICssLength blur, IColor color) {
        this(x, y, blur, ICssLength.ZERO, color, CssBoxShadowType.NORMAL);
    }

    public CssBoxShadow(ICssLength x, ICssLength y, ICssLength blur, ICssLength spread, IColor color) {
        this(x, y, blur, spread, color, CssBoxShadowType.NORMAL);
    }

    public CssBoxShadow(ICssLength x, ICssLength y, IColor color, CssBoxShadowType type) {
        this(x, y, ICssLength.ZERO, ICssLength.ZERO, color, type);
    }

    public CssBoxShadow(ICssLength x, ICssLength y, ICssLength blur, IColor color, CssBoxShadowType type) {
        this(x, y, blur, ICssLength.ZERO, color, type);
    }

    public CssBoxShadow(ICssLength x, ICssLength y, ICssLength blur, ICssLength spread, IColor color, CssBoxShadowType type) {
        this.x = x;
        this.y = y;
        this.blur = blur;
        this.spread = spread;
        this.color = color;
        this.type = type;
    }

    @Override
    public ICssStyle getStyle() {
        return CssStyle.BOX_SHADOW;
    }

    @Override
    public String getValue() {
        String value = String.format("%s %s %s %s %s", this.x, this.y, this.blur, this.spread, this.color.toHtml());
        return this.type == CssBoxShadowType.NORMAL ? value : value + " inset";
    }
}

